/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.util;

import org.apache.logging.log4j.core.util.JsonUtils;
import org.junit.Assert;
import org.junit.Test;

public class JsonUtilsTest {
    @Test
    public void testQuoteCharSequenceAsString() throws Exception {
        StringBuilder output = new StringBuilder();
        StringBuilder builder = new StringBuilder();
        builder.append("foobar");
        JsonUtils.quoteAsString((CharSequence)builder, (StringBuilder)output);
        Assert.assertEquals((Object)"foobar", (Object)output.toString());
        builder.setLength(0);
        output.setLength(0);
        builder.append("\"x\"");
        JsonUtils.quoteAsString((CharSequence)builder, (StringBuilder)output);
        Assert.assertEquals((Object)"\\\"x\\\"", (Object)output.toString());
    }

    @Test
    public void testQuoteLongCharSequenceAsString() throws Exception {
        StringBuilder output = new StringBuilder();
        StringBuilder input = new StringBuilder();
        StringBuilder sb2 = new StringBuilder();
        for (int i = 0; i < 1111; ++i) {
            input.append('\"');
            sb2.append("\\\"");
        }
        String exp = sb2.toString();
        JsonUtils.quoteAsString((CharSequence)input, (StringBuilder)output);
        Assert.assertEquals((long)(2 * input.length()), (long)output.length());
        Assert.assertEquals((Object)exp, (Object)output.toString());
    }

    @Test
    public void testCharSequenceWithCtrlChars() throws Exception {
        char[] input = new char[]{'\u0000', '\u0001', '\u0002', '\u0003', '\u0004'};
        StringBuilder builder = new StringBuilder();
        builder.append(input);
        StringBuilder output = new StringBuilder();
        JsonUtils.quoteAsString((CharSequence)builder, (StringBuilder)output);
        Assert.assertEquals((Object)"\\u0000\\u0001\\u0002\\u0003\\u0004", (Object)output.toString());
    }
}

