/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.util;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import org.apache.logging.log4j.core.util.CronExpression;
import org.junit.Assert;
import org.junit.Test;

public class CronExpressionTest {
    @Test
    public void testDayOfMonth() throws Exception {
        CronExpression parser = new CronExpression("0 */15,12 7-11,13-17 * * ?");
        Date date = new GregorianCalendar(2015, 11, 2).getTime();
        Date fireDate = parser.getNextValidTimeAfter(date);
        Date expected = new GregorianCalendar(2015, 11, 2, 7, 0, 0).getTime();
        Assert.assertEquals((String)"Dates not equal.", (Object)expected, (Object)fireDate);
    }

    @Test
    public void testDayOfWeek() throws Exception {
        CronExpression parser = new CronExpression("0 */15,12 7-11,13-17 ? * Fri");
        Date date = new GregorianCalendar(2015, 11, 2).getTime();
        Date fireDate = parser.getNextValidTimeAfter(date);
        Date expected = new GregorianCalendar(2015, 11, 4, 7, 0, 0).getTime();
        Assert.assertEquals((String)"Dates not equal.", (Object)expected, (Object)fireDate);
    }

    @Test
    public void testNextMonth() throws Exception {
        CronExpression parser = new CronExpression("0 */15,12 7-11,13-17 1 * ?");
        Date date = new GregorianCalendar(2015, 11, 2).getTime();
        Date fireDate = parser.getNextValidTimeAfter(date);
        Date expected = new GregorianCalendar(2016, 0, 1, 7, 0, 0).getTime();
        Assert.assertEquals((String)"Dates not equal.", (Object)expected, (Object)fireDate);
    }

    @Test
    public void testLastDayOfMonth() throws Exception {
        CronExpression parser = new CronExpression("0 */15,12 7-11,13-17 L * ?");
        Date date = new GregorianCalendar(2015, 10, 2).getTime();
        Date fireDate = parser.getNextValidTimeAfter(date);
        Date expected = new GregorianCalendar(2015, 10, 30, 7, 0, 0).getTime();
        Assert.assertEquals((String)"Dates not equal.", (Object)expected, (Object)fireDate);
    }

    @Test
    public void testNextDay() throws Exception {
        CronExpression parser = new CronExpression("0 0 0 * * ?");
        Date date = new GregorianCalendar(2015, 10, 2).getTime();
        Date fireDate = parser.getNextValidTimeAfter(date);
        Date expected = new GregorianCalendar(2015, 10, 3, 0, 0, 0).getTime();
        Assert.assertEquals((String)"Dates not equal.", (Object)expected, (Object)fireDate);
    }

    @Test
    public void testPrevFireTime1() throws Exception {
        CronExpression parser = new CronExpression("0 */15,12 7-11,13-17 L * ?");
        Date date = new GregorianCalendar(2015, 10, 2).getTime();
        Date fireDate = parser.getPrevFireTime(date);
        Date expected = new GregorianCalendar(2015, 9, 31, 17, 45, 0).getTime();
        Assert.assertEquals((String)"Dates not equal.", (Object)expected, (Object)fireDate);
    }

    @Test
    public void testPrevFireTime2() throws Exception {
        CronExpression parser = new CronExpression("0 0/5 14,18 * * ?");
        Date date = new GregorianCalendar(2015, 10, 2).getTime();
        Date fireDate = parser.getPrevFireTime(date);
        Date expected = new GregorianCalendar(2015, 10, 1, 18, 55, 0).getTime();
        Assert.assertEquals((String)"Dates not equal.", (Object)expected, (Object)fireDate);
    }

    @Test
    public void testPrevFireTime3() throws Exception {
        CronExpression parser = new CronExpression("0 35/10 * * * ?");
        Date date = new GregorianCalendar(2015, 10, 2).getTime();
        Date fireDate = parser.getPrevFireTime(date);
        Date expected = new GregorianCalendar(2015, 10, 1, 23, 55, 0).getTime();
        Assert.assertEquals((String)"Dates not equal.", (Object)expected, (Object)fireDate);
    }

    @Test
    public void testPrevFireTimeTenFifteen() throws Exception {
        CronExpression parser = new CronExpression("0 15 10 * * ? *");
        Date date = new GregorianCalendar(2015, 10, 2).getTime();
        Date fireDate = parser.getPrevFireTime(date);
        Date expected = new GregorianCalendar(2015, 10, 1, 10, 15, 0).getTime();
        Assert.assertEquals((String)"Dates not equal.", (Object)expected, (Object)fireDate);
    }

    @Test
    public void testPrevFireTimeTwoPM() throws Exception {
        CronExpression parser = new CronExpression("0 * 14 * * ?");
        Date date = new GregorianCalendar(2015, 10, 2).getTime();
        Date fireDate = parser.getPrevFireTime(date);
        Date expected = new GregorianCalendar(2015, 10, 1, 14, 59, 0).getTime();
        Assert.assertEquals((String)"Dates not equal.", (Object)expected, (Object)fireDate);
    }

    @Test
    public void testPrevFireTimeMarch() throws Exception {
        CronExpression parser = new CronExpression("0 10,44 14 ? 3 WED");
        Date date = new GregorianCalendar(2015, 10, 2).getTime();
        Date fireDate = parser.getPrevFireTime(date);
        Date expected = new GregorianCalendar(2015, 2, 25, 14, 44, 0).getTime();
        Assert.assertEquals((String)"Dates not equal.", (Object)expected, (Object)fireDate);
    }

    @Test
    public void testPrevFireTimeThirdFriday() throws Exception {
        CronExpression parser = new CronExpression("0 15 10 ? * 6#3");
        Date date = new GregorianCalendar(2015, 10, 2).getTime();
        Date fireDate = parser.getPrevFireTime(date);
        Date expected = new GregorianCalendar(2015, 9, 16, 10, 15, 0).getTime();
        Assert.assertEquals((String)"Dates not equal.", (Object)expected, (Object)fireDate);
    }

    @Test
    public void testTimeBeforeMilliseconds() throws Exception {
        CronExpression parser = new CronExpression("0 0 0 * * ?");
        GregorianCalendar cal = new GregorianCalendar(2015, 10, 2, 0, 0, 0);
        cal.set(14, 100);
        Date date = cal.getTime();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
        System.err.println(sdf.format(date));
        Date fireDate = parser.getTimeBefore(date);
        System.err.println(sdf.format(fireDate));
        Date expected = new GregorianCalendar(2015, 10, 1, 0, 0, 0).getTime();
        Assert.assertEquals((String)"Dates not equal.", (Object)expected, (Object)fireDate);
    }
}

