/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.pattern;

import java.util.List;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.junit.LoggerContextRule;
import org.apache.logging.log4j.test.appender.ListAppender;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;

public class ThrowableTest {
    private static final String CONFIG = "log4j-throwable.xml";
    private static ListAppender app;
    @ClassRule
    public static LoggerContextRule context;
    Logger logger = context.getLogger("LoggerTest");

    @Before
    public void setUp() throws Exception {
        app = context.getListAppender("List").clear();
    }

    @Test
    public void testException() {
        NullPointerException cause = new NullPointerException("null pointer");
        IllegalArgumentException parent = new IllegalArgumentException("IllegalArgument", cause);
        this.logger.error("Exception", (Throwable)parent);
        List<String> msgs = app.getMessages();
        Assert.assertNotNull(msgs);
        Assert.assertEquals((String)("Incorrect number of messages. Should be 1 is " + msgs.size()), (long)1L, (long)msgs.size());
        Assert.assertFalse((String)"No suppressed lines", (boolean)msgs.get(0).contains("suppressed"));
    }

    static {
        context = new LoggerContextRule(CONFIG);
    }
}

