/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.lookup;

import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;
import org.apache.logging.log4j.junit.LoggerContextRule;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;

public class MarkerLookupConfigTest {
    @ClassRule
    public static LoggerContextRule context = new LoggerContextRule("log4j-marker-lookup.yaml");
    public static final Marker PAYLOAD = MarkerManager.getMarker((String)"PAYLOAD");
    private static final String PAYLOAD_LOG = "Message in payload.log";
    public static final Marker PERFORMANCE = MarkerManager.getMarker((String)"PERFORMANCE");
    private static final String PERFORMANCE_LOG = "Message in performance.log";
    public static final Marker SQL = MarkerManager.getMarker((String)"SQL");
    private static final String SQL_LOG = "Message in sql.log";

    @Test
    public void test() throws IOException {
        Logger logger = LogManager.getLogger();
        logger.info(SQL, SQL_LOG);
        logger.info(PAYLOAD, PAYLOAD_LOG);
        logger.info(PERFORMANCE, PERFORMANCE_LOG);
        String log = FileUtils.readFileToString((File)new File("target/logs/sql.log"));
        Assert.assertTrue((boolean)log.contains(SQL_LOG));
        Assert.assertFalse((boolean)log.contains(PAYLOAD_LOG));
        Assert.assertFalse((boolean)log.contains(PERFORMANCE_LOG));
        log = FileUtils.readFileToString((File)new File("target/logs/payload.log"));
        Assert.assertFalse((boolean)log.contains(SQL_LOG));
        Assert.assertTrue((boolean)log.contains(PAYLOAD_LOG));
        Assert.assertFalse((boolean)log.contains(PERFORMANCE_LOG));
        log = FileUtils.readFileToString((File)new File("target/logs/performance.log"));
        Assert.assertFalse((boolean)log.contains(SQL_LOG));
        Assert.assertFalse((boolean)log.contains(PAYLOAD_LOG));
        Assert.assertTrue((boolean)log.contains(PERFORMANCE_LOG));
    }
}

