/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.lookup;

import java.io.File;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.ThreadContext;
import org.apache.logging.log4j.core.lookup.ContextMapLookup;
import org.apache.logging.log4j.junit.LoggerContextRule;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

public class ContextMapLookupTest {
    private static final String TESTKEY = "TestKey";
    private static final String TESTVAL = "TestValue";
    private final LoggerContextRule context = new LoggerContextRule("ContextMapLookupTest.xml");
    @Rule
    public RuleChain chain = RuleChain.outerRule((TestRule)new TestRule(){

        public Statement apply(final Statement base, final Description description) {
            return new Statement(){

                public void evaluate() throws Throwable {
                    File logFile = new File("target", description.getClassName() + '.' + description.getMethodName() + ".log");
                    ThreadContext.put((String)"testClassName", (String)description.getClassName());
                    ThreadContext.put((String)"testMethodName", (String)description.getMethodName());
                    try {
                        base.evaluate();
                    }
                    finally {
                        ThreadContext.remove((String)"testClassName");
                        ThreadContext.remove((String)"testMethodName");
                        if (logFile.exists()) {
                            logFile.deleteOnExit();
                        }
                    }
                }
            };
        }
    }).around((TestRule)this.context);

    @Test
    public void testLookup() {
        ThreadContext.put((String)TESTKEY, (String)TESTVAL);
        ContextMapLookup lookup = new ContextMapLookup();
        String value = lookup.lookup(TESTKEY);
        Assert.assertEquals((Object)TESTVAL, (Object)value);
        value = lookup.lookup("BadKey");
        Assert.assertNull((Object)value);
    }

    @Test
    public void testFileLog() throws Exception {
        Logger logger = LogManager.getLogger();
        logger.info("Hello from testFileLog!");
        File logFile = new File("target", this.getClass().getName() + ".testFileLog.log");
        Assert.assertTrue((boolean)logFile.exists());
    }
}

