/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.layout;

import java.io.Serializable;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.ThreadContext;
import org.apache.logging.log4j.categories.Layouts;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.BasicConfigurationFactory;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.Logger;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.async.RingBufferLogEvent;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.ConfigurationFactory;
import org.apache.logging.log4j.core.impl.Log4jLogEvent;
import org.apache.logging.log4j.core.impl.MutableLogEvent;
import org.apache.logging.log4j.core.jackson.Log4jJsonObjectMapper;
import org.apache.logging.log4j.core.layout.JsonLayout;
import org.apache.logging.log4j.core.layout.LogEventFixtures;
import org.apache.logging.log4j.core.lookup.JavaLookup;
import org.apache.logging.log4j.core.util.Clock;
import org.apache.logging.log4j.core.util.DummyNanoClock;
import org.apache.logging.log4j.core.util.KeyValuePair;
import org.apache.logging.log4j.core.util.NanoClock;
import org.apache.logging.log4j.core.util.SystemClock;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.ObjectMessage;
import org.apache.logging.log4j.message.ReusableMessageFactory;
import org.apache.logging.log4j.message.SimpleMessage;
import org.apache.logging.log4j.spi.AbstractLogger;
import org.apache.logging.log4j.test.appender.ListAppender;
import org.apache.logging.log4j.util.SortedArrayStringMap;
import org.apache.logging.log4j.util.StringMap;
import org.apache.logging.log4j.util.Strings;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={Layouts.Json.class})
public class JsonLayoutTest {
    static ConfigurationFactory cf = new BasicConfigurationFactory();
    private static final String DQUOTE = "\"";
    LoggerContext ctx = LoggerContext.getContext();
    Logger rootLogger = this.ctx.getRootLogger();

    @AfterClass
    public static void cleanupClass() {
        ConfigurationFactory.removeConfigurationFactory((ConfigurationFactory)cf);
        ThreadContext.clearAll();
    }

    @BeforeClass
    public static void setupClass() {
        ThreadContext.clearAll();
        ConfigurationFactory.setConfigurationFactory((ConfigurationFactory)cf);
        LoggerContext ctx = LoggerContext.getContext();
        ctx.reconfigure();
    }

    private void checkAt(String expected, int lineIndex, List<String> list) {
        String trimedLine = list.get(lineIndex).trim();
        Assert.assertTrue((String)("Incorrect line index " + lineIndex + ": " + Strings.dquote((String)trimedLine)), (boolean)trimedLine.equals(expected));
    }

    private void checkContains(String expected, List<String> list) {
        for (String string : list) {
            String trimedLine = string.trim();
            if (!trimedLine.equals(expected)) continue;
            return;
        }
        Assert.fail((String)("Cannot find " + expected + " in " + list));
    }

    private void checkMapEntry(String key, String value, boolean compact, String str, boolean contextMapAslist) {
        this.toPropertySeparator(compact);
        if (contextMapAslist) {
            String expected = String.format("{\"key\":\"%s\",\"value\":\"%s\"}", key, value);
            Assert.assertTrue((String)("Cannot find contextMapAslist " + expected + " in " + str), (boolean)str.contains(expected));
        } else {
            String expected = String.format("\"%s\":\"%s\"", key, value);
            Assert.assertTrue((String)("Cannot find contextMap " + expected + " in " + str), (boolean)str.contains(expected));
        }
    }

    private void checkProperty(String key, String value, boolean compact, String str) {
        String propSep = this.toPropertySeparator(compact);
        String expected = String.format("\"%s\"%s\"%s\"", key, propSep, value);
        Assert.assertTrue((String)("Cannot find " + expected + " in " + str), (boolean)str.contains(expected));
    }

    private void checkPropertyName(String name, boolean compact, String str) {
        String propSep = this.toPropertySeparator(compact);
        Assert.assertTrue((String)str, (boolean)str.contains(DQUOTE + name + DQUOTE + propSep));
    }

    private void checkPropertyNameAbsent(String name, boolean compact, String str) {
        String propSep = this.toPropertySeparator(compact);
        Assert.assertFalse((String)str, (boolean)str.contains(DQUOTE + name + DQUOTE + propSep));
    }

    private void testAllFeatures(boolean locationInfo, boolean compact, boolean eventEol, String endOfLine, boolean includeContext, boolean contextMapAslist, boolean includeStacktrace) throws Exception {
        Log4jLogEvent expected = LogEventFixtures.createLogEvent();
        JsonLayout layout = ((JsonLayout.Builder)((JsonLayout.Builder)((JsonLayout.Builder)((JsonLayout.Builder)((JsonLayout.Builder)((JsonLayout.Builder)((JsonLayout.Builder)((JsonLayout.Builder)JsonLayout.newBuilder().setLocationInfo(locationInfo)).setProperties(includeContext)).setPropertiesAsList(contextMapAslist).setComplete(false)).setCompact(compact)).setEventEol(eventEol)).setEndOfLine(endOfLine)).setCharset(StandardCharsets.UTF_8)).setIncludeStacktrace(includeStacktrace)).build();
        String str = layout.toSerializable((LogEvent)expected);
        this.toPropertySeparator(compact);
        if (endOfLine == null) {
            Assert.assertEquals((String)str, (Object)(!compact || eventEol ? 1 : 0), (Object)str.contains("\n"));
        } else {
            Assert.assertEquals((String)str, (Object)(!compact || eventEol ? 1 : 0), (Object)str.contains(endOfLine));
            Assert.assertEquals((String)str, (Object)(compact && eventEol ? 1 : 0), (Object)str.endsWith(endOfLine));
        }
        Assert.assertEquals((String)str, (Object)locationInfo, (Object)str.contains("source"));
        Assert.assertEquals((String)str, (Object)includeContext, (Object)str.contains("contextMap"));
        Log4jLogEvent actual = (Log4jLogEvent)new Log4jJsonObjectMapper(contextMapAslist, includeStacktrace, false, false).readValue(str, Log4jLogEvent.class);
        LogEventFixtures.assertEqualLogEvents((LogEvent)expected, (LogEvent)actual, locationInfo, includeContext, includeStacktrace);
        if (includeContext) {
            this.checkMapEntry("MDC.A", "A_Value", compact, str, contextMapAslist);
            this.checkMapEntry("MDC.B", "B_Value", compact, str, contextMapAslist);
        }
        Assert.assertNull((Object)actual.getThrown());
        this.checkPropertyName("instant", compact, str);
        this.checkPropertyName("thread", compact, str);
        this.checkPropertyName("level", compact, str);
        this.checkPropertyName("loggerName", compact, str);
        this.checkPropertyName("marker", compact, str);
        this.checkPropertyName("name", compact, str);
        this.checkPropertyName("parents", compact, str);
        this.checkPropertyName("message", compact, str);
        this.checkPropertyName("thrown", compact, str);
        this.checkPropertyName("cause", compact, str);
        this.checkPropertyName("commonElementCount", compact, str);
        this.checkPropertyName("localizedMessage", compact, str);
        if (includeStacktrace) {
            this.checkPropertyName("extendedStackTrace", compact, str);
            this.checkPropertyName("class", compact, str);
            this.checkPropertyName("method", compact, str);
            this.checkPropertyName("file", compact, str);
            this.checkPropertyName("line", compact, str);
            this.checkPropertyName("exact", compact, str);
            this.checkPropertyName("location", compact, str);
            this.checkPropertyName("version", compact, str);
        } else {
            this.checkPropertyNameAbsent("extendedStackTrace", compact, str);
        }
        this.checkPropertyName("suppressed", compact, str);
        this.checkPropertyName("loggerFqcn", compact, str);
        this.checkPropertyName("endOfBatch", compact, str);
        if (includeContext) {
            this.checkPropertyName("contextMap", compact, str);
        } else {
            this.checkPropertyNameAbsent("contextMap", compact, str);
        }
        this.checkPropertyName("contextStack", compact, str);
        if (locationInfo) {
            this.checkPropertyName("source", compact, str);
        } else {
            this.checkPropertyNameAbsent("source", compact, str);
        }
        this.checkProperty("loggerFqcn", "f.q.c.n", compact, str);
        this.checkProperty("loggerName", "a.B", compact, str);
    }

    @Test
    public void testContentType() {
        JsonLayout layout = JsonLayout.createDefaultLayout();
        Assert.assertEquals((Object)"application/json; charset=UTF-8", (Object)layout.getContentType());
    }

    @Test
    public void testDefaultCharset() {
        JsonLayout layout = JsonLayout.createDefaultLayout();
        Assert.assertEquals((Object)StandardCharsets.UTF_8, (Object)layout.getCharset());
    }

    @Test
    public void testEscapeLayout() throws Exception {
        Map appenders = this.rootLogger.getAppenders();
        for (Appender appender : appenders.values()) {
            this.rootLogger.removeAppender(appender);
        }
        Configuration configuration = this.rootLogger.getContext().getConfiguration();
        boolean propertiesAsList = false;
        JsonLayout layout = ((JsonLayout.Builder)((JsonLayout.Builder)((JsonLayout.Builder)((JsonLayout.Builder)((JsonLayout.Builder)((JsonLayout.Builder)((JsonLayout.Builder)JsonLayout.newBuilder().setConfiguration(configuration)).setLocationInfo(true)).setProperties(true)).setPropertiesAsList(false).setComplete(true)).setCompact(false)).setEventEol(false)).setIncludeStacktrace(true)).build();
        ListAppender appender = new ListAppender("List", null, (Layout<? extends Serializable>)layout, true, false);
        appender.start();
        this.rootLogger.addAppender((Appender)appender);
        this.rootLogger.setLevel(Level.DEBUG);
        this.rootLogger.debug("Here is a quote ' and then a double quote \"");
        appender.stop();
        List<String> list = appender.getMessages();
        this.checkAt("[", 0, list);
        this.checkAt("{", 1, list);
        this.checkContains("\"level\" : \"DEBUG\",", list);
        this.checkContains("\"message\" : \"Here is a quote ' and then a double quote \\\"\",", list);
        this.checkContains("\"loggerFqcn\" : \"" + AbstractLogger.class.getName() + "\",", list);
        for (Appender app : appenders.values()) {
            this.rootLogger.addAppender(app);
        }
    }

    @Test
    public void testLayout() throws Exception {
        Map appenders = this.rootLogger.getAppenders();
        for (Appender appender : appenders.values()) {
            this.rootLogger.removeAppender(appender);
        }
        Configuration configuration = this.rootLogger.getContext().getConfiguration();
        boolean propertiesAsList = false;
        JsonLayout layout = ((JsonLayout.Builder)((JsonLayout.Builder)((JsonLayout.Builder)((JsonLayout.Builder)((JsonLayout.Builder)((JsonLayout.Builder)((JsonLayout.Builder)((JsonLayout.Builder)((JsonLayout.Builder)JsonLayout.newBuilder().setConfiguration(configuration)).setLocationInfo(true)).setProperties(true)).setPropertiesAsList(false).setComplete(true)).setCompact(false)).setEventEol(false)).setHeader("[[".getBytes(Charset.defaultCharset()))).setFooter("]]".getBytes(Charset.defaultCharset()))).setIncludeStacktrace(true)).build();
        ListAppender appender = new ListAppender("List", null, (Layout<? extends Serializable>)layout, true, false);
        appender.start();
        this.rootLogger.addAppender((Appender)appender);
        this.rootLogger.setLevel(Level.DEBUG);
        this.rootLogger.debug("starting mdc pattern test");
        this.rootLogger.debug("empty mdc");
        ThreadContext.put((String)"key1", (String)"value1");
        ThreadContext.put((String)"key2", (String)"value2");
        this.rootLogger.debug("filled mdc");
        ThreadContext.remove((String)"key1");
        ThreadContext.remove((String)"key2");
        this.rootLogger.error("finished mdc pattern test", (Throwable)new NullPointerException("test"));
        appender.stop();
        List<String> list = appender.getMessages();
        this.checkAt("[[", 0, list);
        this.checkAt("{", 1, list);
        this.checkContains("\"loggerFqcn\" : \"" + AbstractLogger.class.getName() + "\",", list);
        this.checkContains("\"level\" : \"DEBUG\",", list);
        this.checkContains("\"message\" : \"starting mdc pattern test\",", list);
        for (Appender app : appenders.values()) {
            this.rootLogger.addAppender(app);
        }
    }

    @Test
    public void testLayoutLoggerName() throws Exception {
        boolean propertiesAsList = false;
        JsonLayout layout = ((JsonLayout.Builder)((JsonLayout.Builder)((JsonLayout.Builder)((JsonLayout.Builder)((JsonLayout.Builder)((JsonLayout.Builder)((JsonLayout.Builder)JsonLayout.newBuilder().setLocationInfo(false)).setProperties(false)).setPropertiesAsList(false).setComplete(false)).setCompact(true)).setEventEol(false)).setCharset(StandardCharsets.UTF_8)).setIncludeStacktrace(true)).build();
        Log4jLogEvent expected = Log4jLogEvent.newBuilder().setLoggerName("a.B").setLoggerFqcn("f.q.c.n").setLevel(Level.DEBUG).setMessage((Message)new SimpleMessage("M")).setThreadName("threadName").setTimeMillis(1L).build();
        String str = layout.toSerializable((LogEvent)expected);
        Assert.assertTrue((String)str, (boolean)str.contains("\"loggerName\":\"a.B\""));
        Log4jLogEvent actual = (Log4jLogEvent)new Log4jJsonObjectMapper(false, true, false, false).readValue(str, Log4jLogEvent.class);
        Assert.assertEquals((Object)expected.getLoggerName(), (Object)actual.getLoggerName());
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testAdditionalFields() throws Exception {
        JsonLayout layout = ((JsonLayout.Builder)((JsonLayout.Builder)((JsonLayout.Builder)((JsonLayout.Builder)((JsonLayout.Builder)((JsonLayout.Builder)((JsonLayout.Builder)((JsonLayout.Builder)JsonLayout.newBuilder().setLocationInfo(false)).setProperties(false)).setComplete(false)).setCompact(true)).setEventEol(false)).setIncludeStacktrace(false)).setAdditionalFields(new KeyValuePair[]{new KeyValuePair("KEY1", "VALUE1"), new KeyValuePair("KEY2", "${java:runtime}")}).setCharset(StandardCharsets.UTF_8)).setConfiguration(this.ctx.getConfiguration())).build();
        String str = layout.toSerializable((LogEvent)LogEventFixtures.createLogEvent());
        Assert.assertTrue((String)str, (boolean)str.contains("\"KEY1\":\"VALUE1\""));
        Assert.assertTrue((String)str, (boolean)str.contains("\"KEY2\":\"" + new JavaLookup().getRuntime() + DQUOTE));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testReusableLayoutMessageWithCurlyBraces() throws Exception {
        boolean propertiesAsList = false;
        JsonLayout layout = ((JsonLayout.Builder)((JsonLayout.Builder)((JsonLayout.Builder)((JsonLayout.Builder)((JsonLayout.Builder)((JsonLayout.Builder)((JsonLayout.Builder)JsonLayout.newBuilder().setLocationInfo(false)).setProperties(false)).setPropertiesAsList(false).setComplete(false)).setCompact(true)).setEventEol(false)).setCharset(StandardCharsets.UTF_8)).setIncludeStacktrace(true)).build();
        Message message = ReusableMessageFactory.INSTANCE.newMessage("Testing {}", (Object)new TestObj());
        try {
            Log4jLogEvent expected = Log4jLogEvent.newBuilder().setLoggerName("a.B").setLoggerFqcn("f.q.c.n").setLevel(Level.DEBUG).setMessage(message).setThreadName("threadName").setTimeMillis(1L).build();
            MutableLogEvent mutableLogEvent = new MutableLogEvent();
            mutableLogEvent.initFrom((LogEvent)expected);
            String str = layout.toSerializable((LogEvent)mutableLogEvent);
            String expectedMessage = "Testing This is my toString {} with curly braces";
            Assert.assertTrue((String)str, (boolean)str.contains("\"message\":\"Testing This is my toString {} with curly braces\""));
            Log4jLogEvent actual = (Log4jLogEvent)new Log4jJsonObjectMapper(false, true, false, false).readValue(str, Log4jLogEvent.class);
            Assert.assertEquals((Object)"Testing This is my toString {} with curly braces", (Object)actual.getMessage().getFormattedMessage());
        }
        finally {
            ReusableMessageFactory.release((Message)message);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLayoutRingBufferEventReusableMessageWithCurlyBraces() throws Exception {
        boolean propertiesAsList = false;
        JsonLayout layout = ((JsonLayout.Builder)((JsonLayout.Builder)((JsonLayout.Builder)((JsonLayout.Builder)((JsonLayout.Builder)((JsonLayout.Builder)((JsonLayout.Builder)JsonLayout.newBuilder().setLocationInfo(false)).setProperties(false)).setPropertiesAsList(false).setComplete(false)).setCompact(true)).setEventEol(false)).setCharset(StandardCharsets.UTF_8)).setIncludeStacktrace(true)).build();
        Message message = ReusableMessageFactory.INSTANCE.newMessage("Testing {}", (Object)new TestObj());
        try {
            RingBufferLogEvent ringBufferEvent = new RingBufferLogEvent();
            ringBufferEvent.setValues(null, "a.B", null, "f.q.c.n", Level.DEBUG, message, null, (StringMap)new SortedArrayStringMap(), (ThreadContext.ContextStack)ThreadContext.EMPTY_STACK, 1L, "threadName", 1, null, (Clock)new SystemClock(), (NanoClock)new DummyNanoClock());
            String str = layout.toSerializable((LogEvent)ringBufferEvent);
            String expectedMessage = "Testing This is my toString {} with curly braces";
            MatcherAssert.assertThat((Object)str, (Matcher)CoreMatchers.containsString((String)"\"message\":\"Testing This is my toString {} with curly braces\""));
            Log4jLogEvent actual = (Log4jLogEvent)new Log4jJsonObjectMapper(false, true, false, false).readValue(str, Log4jLogEvent.class);
            Assert.assertEquals((Object)"Testing This is my toString {} with curly braces", (Object)actual.getMessage().getFormattedMessage());
        }
        finally {
            ReusableMessageFactory.release((Message)message);
        }
    }

    @Test
    public void testLocationOffCompactOffMdcOff() throws Exception {
        this.testAllFeatures(false, false, false, null, false, false, true);
    }

    @Test
    public void testLocationOnCompactOnMdcOn() throws Exception {
        this.testAllFeatures(true, true, false, null, true, false, true);
    }

    @Test
    public void testLocationOnCompactOnEventEolOnMdcOn() throws Exception {
        this.testAllFeatures(true, true, true, null, true, false, true);
    }

    @Test
    public void testLocationOnCompactOnEventEolOnMdcOnMdcAsList() throws Exception {
        this.testAllFeatures(true, true, true, null, true, true, true);
    }

    @Test
    public void testExcludeStacktrace() throws Exception {
        this.testAllFeatures(false, false, false, null, false, false, false);
    }

    @Test
    public void testLocationOnCustomEndOfLine() throws Exception {
        this.testAllFeatures(true, true, true, "CUSTOM_END_OF_LINE", true, false, true);
    }

    @Test
    public void testStacktraceAsString() throws Exception {
        String str = this.prepareJSONForStacktraceTests(true);
        Assert.assertTrue((String)str, (boolean)str.contains("\"extendedStackTrace\":\"java.lang.NullPointerException"));
    }

    @Test
    public void testStacktraceAsNonString() throws Exception {
        String str = this.prepareJSONForStacktraceTests(false);
        Assert.assertTrue((String)str, (boolean)str.contains("\"extendedStackTrace\":["));
    }

    private String prepareJSONForStacktraceTests(boolean stacktraceAsString) {
        Log4jLogEvent expected = LogEventFixtures.createLogEvent();
        JsonLayout layout = ((JsonLayout.Builder)((JsonLayout.Builder)((JsonLayout.Builder)JsonLayout.newBuilder().setCompact(true)).setIncludeStacktrace(true)).setStacktraceAsString(stacktraceAsString)).build();
        return layout.toSerializable((LogEvent)expected);
    }

    @Test
    public void testObjectMessageAsJsonString() {
        String str = this.prepareJSONForObjectMessageAsJsonObjectTests(1234, false);
        Assert.assertTrue((String)str, (boolean)str.contains("\"message\":\"" + this.getClass().getCanonicalName() + "$TestClass@"));
    }

    @Test
    public void testObjectMessageAsJsonObject() {
        String str = this.prepareJSONForObjectMessageAsJsonObjectTests(1234, true);
        Assert.assertTrue((String)str, (boolean)str.contains("\"message\":{\"value\":1234}"));
    }

    private String prepareJSONForObjectMessageAsJsonObjectTests(int value, boolean objectMessageAsJsonObject) {
        TestClass testClass = new TestClass();
        testClass.setValue(value);
        Log4jLogEvent expected = Log4jLogEvent.newBuilder().setLoggerName("a.B").setLoggerFqcn("f.q.c.n").setLevel(Level.DEBUG).setMessage((Message)new ObjectMessage((Object)testClass)).setThreadName("threadName").setTimeMillis(1L).build();
        JsonLayout layout = ((JsonLayout.Builder)JsonLayout.newBuilder().setCompact(true)).setObjectMessageAsJsonObject(objectMessageAsJsonObject).build();
        return layout.toSerializable((LogEvent)expected);
    }

    @Test
    public void testInstantSortsBeforeMessage() {
        String str = this.prepareJSONForEventWithTimeAsInstant();
        Assert.assertTrue((String)str, (boolean)str.startsWith("{\"instant\":{\"epochSecond\":0,\"nanoOfSecond\":1000000},"));
        Assert.assertTrue((String)str, (boolean)str.contains("\"message\":\"message\""));
    }

    private String prepareJSONForEventWithTimeAsInstant() {
        TestClass testClass = new TestClass();
        Log4jLogEvent expected = Log4jLogEvent.newBuilder().setLoggerName("a.B").setLoggerFqcn("f.q.c.n").setLevel(Level.DEBUG).setMessage((Message)new SimpleMessage("message")).setThreadName("threadName").setTimeMillis(1L).build();
        JsonLayout layout = ((JsonLayout.Builder)JsonLayout.newBuilder().setCompact(true)).build();
        return layout.toSerializable((LogEvent)expected);
    }

    @Test
    public void testIncludeNullDelimiterTrue() throws Exception {
        JsonLayout layout = ((JsonLayout.Builder)((JsonLayout.Builder)JsonLayout.newBuilder().setCompact(true)).setIncludeNullDelimiter(true)).build();
        String str = layout.toSerializable((LogEvent)LogEventFixtures.createLogEvent());
        Assert.assertTrue((boolean)str.endsWith("\u0000"));
    }

    @Test
    public void testIncludeNullDelimiterFalse() throws Exception {
        JsonLayout layout = ((JsonLayout.Builder)((JsonLayout.Builder)JsonLayout.newBuilder().setCompact(true)).setIncludeNullDelimiter(false)).build();
        String str = layout.toSerializable((LogEvent)LogEventFixtures.createLogEvent());
        Assert.assertFalse((boolean)str.endsWith("\u0000"));
    }

    private String toPropertySeparator(boolean compact) {
        return compact ? ":" : " : ";
    }

    private static class TestClass {
        private int value;

        private TestClass() {
        }

        public int getValue() {
            return this.value;
        }

        public void setValue(int value) {
            this.value = value;
        }
    }

    static class TestObj {
        static final String TO_STRING_VALUE = "This is my toString {} with curly braces";

        TestObj() {
        }

        public String toString() {
            return TO_STRING_VALUE;
        }
    }
}

