/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.layout;

import java.nio.charset.Charset;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.layout.AbstractStringLayout;
import org.junit.Assert;
import org.junit.Test;

public class AbstractStringLayoutTest {
    @Test
    public void testGetStringBuilderCapacityRestrictedToMax() throws Exception {
        StringBuilder sb = ConcreteStringLayout.getStringBuilder();
        int initialCapacity = sb.capacity();
        Assert.assertEquals((String)"initial capacity", (long)ConcreteStringLayout.DEFAULT_STRING_BUILDER_SIZE, (long)sb.capacity());
        int SMALL = 100;
        String smallMessage = new String(new char[100]);
        sb.append(smallMessage);
        Assert.assertTrue((String)"capacity not grown", (sb.capacity() == initialCapacity ? 1 : 0) != 0);
        Assert.assertEquals((String)"length=msg length", (long)100L, (long)sb.length());
        StringBuilder sb2 = ConcreteStringLayout.getStringBuilder();
        Assert.assertEquals((String)"capacity unchanged", (long)sb2.capacity(), (long)initialCapacity);
        Assert.assertEquals((String)"empty, ready for use", (long)0L, (long)sb2.length());
        int LARGE = ConcreteStringLayout.MAX_STRING_BUILDER_SIZE * 2;
        String largeMessage = new String(new char[LARGE]);
        sb2.append(largeMessage);
        Assert.assertTrue((String)"capacity grown to fit msg length", (sb2.capacity() >= LARGE ? 1 : 0) != 0);
        Assert.assertTrue((String)"capacity is now greater than max length", (sb2.capacity() >= ConcreteStringLayout.MAX_STRING_BUILDER_SIZE ? 1 : 0) != 0);
        Assert.assertEquals((String)"length=msg length", (long)LARGE, (long)sb2.length());
        sb2.setLength(0);
        Assert.assertEquals((String)"empty, cleared", (long)0L, (long)sb2.length());
        Assert.assertTrue((String)"capacity remains very large", (sb2.capacity() >= ConcreteStringLayout.MAX_STRING_BUILDER_SIZE ? 1 : 0) != 0);
        StringBuilder sb3 = ConcreteStringLayout.getStringBuilder();
        Assert.assertEquals((String)"capacity, trimmed to MAX_STRING_BUILDER_SIZE", (long)ConcreteStringLayout.MAX_STRING_BUILDER_SIZE, (long)sb3.capacity());
        Assert.assertEquals((String)"empty, ready for use", (long)0L, (long)sb3.length());
    }

    static class ConcreteStringLayout
    extends AbstractStringLayout {
        public static int DEFAULT_STRING_BUILDER_SIZE = 1024;
        public static int MAX_STRING_BUILDER_SIZE = AbstractStringLayout.MAX_STRING_BUILDER_SIZE;

        public ConcreteStringLayout() {
            super(Charset.defaultCharset());
        }

        public static StringBuilder getStringBuilder() {
            return AbstractStringLayout.getStringBuilder();
        }

        public String toSerializable(LogEvent event) {
            return null;
        }
    }
}

