/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.jackson;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.ObjectWriter;
import java.io.IOException;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.categories.Layouts;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={Layouts.Json.class})
public abstract class LevelMixInTest {
    private ObjectMapper log4jObjectMapper;
    private ObjectReader reader;
    private ObjectWriter writer;

    @Before
    public void setUp() {
        this.log4jObjectMapper = this.newObjectMapper();
        this.writer = this.log4jObjectMapper.writer();
        this.reader = this.log4jObjectMapper.readerFor(Level.class);
    }

    protected abstract ObjectMapper newObjectMapper();

    @Test
    public void testContainer() throws IOException {
        Fixture expected = new Fixture();
        String str = this.writer.writeValueAsString((Object)expected);
        Assert.assertTrue((boolean)str.contains("DEBUG"));
        ObjectReader fixtureReader = this.log4jObjectMapper.readerFor(Fixture.class);
        Fixture actual = (Fixture)fixtureReader.readValue(str);
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testNameOnly() throws IOException {
        Level expected = Level.getLevel((String)"DEBUG");
        String str = this.writer.writeValueAsString((Object)expected);
        Assert.assertTrue((boolean)str.contains("DEBUG"));
        Level actual = (Level)this.reader.readValue(str);
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    static class Fixture {
        @JsonProperty
        private final Level level = Level.DEBUG;

        Fixture() {
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Fixture other = (Fixture)obj;
            return !(this.level == null ? other.level != null : !this.level.equals((Object)other.level));
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.level == null ? 0 : this.level.hashCode());
            return result;
        }
    }
}

