/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.impl;

import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.junit.LoggerContextRule;
import org.apache.logging.log4j.test.appender.ListAppender;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;

public class NestedLoggingFromToStringTest {
    @Rule
    public LoggerContextRule context = new LoggerContextRule("log4j-sync-to-list.xml");
    private ListAppender listAppender;
    private Logger logger;

    @BeforeClass
    public static void beforeClass() {
        System.setProperty("log4j2.is.webapp", "false");
    }

    @Before
    public void before() {
        this.listAppender = this.context.getListAppender("List");
        this.logger = LogManager.getLogger(NestedLoggingFromToStringTest.class);
    }

    @Test
    public void testNestedLoggingInLastArgument() {
        ParameterizedLoggingThing it = new ParameterizedLoggingThing();
        this.logger.info("main: argCount={} it={}", (Object)"2", (Object)it);
        List<String> list = this.listAppender.getMessages();
        String expect1 = "DEBUG org.apache.logging.log4j.core.impl.NestedLoggingFromToStringTest.ParameterizedLoggingThing getX: values x=3 y=4 z=5";
        String expect2 = "INFO org.apache.logging.log4j.core.impl.NestedLoggingFromToStringTest main: argCount=2 it=[ParameterizedLoggingThing x=3 y=4 z=5]";
        Assert.assertEquals((Object)"DEBUG org.apache.logging.log4j.core.impl.NestedLoggingFromToStringTest.ParameterizedLoggingThing getX: values x=3 y=4 z=5", (Object)list.get(0));
        Assert.assertEquals((Object)"INFO org.apache.logging.log4j.core.impl.NestedLoggingFromToStringTest main: argCount=2 it=[ParameterizedLoggingThing x=3 y=4 z=5]", (Object)list.get(1));
    }

    @Test
    public void testNestedLoggingInFirstArgument() {
        ParameterizedLoggingThing it = new ParameterizedLoggingThing();
        this.logger.info("next: it={} some{} other{}", (Object)it, (Object)"AA", (Object)"BB");
        List<String> list = this.listAppender.getMessages();
        String expect1 = "DEBUG org.apache.logging.log4j.core.impl.NestedLoggingFromToStringTest.ParameterizedLoggingThing getX: values x=3 y=4 z=5";
        String expect2 = "INFO org.apache.logging.log4j.core.impl.NestedLoggingFromToStringTest next: it=[ParameterizedLoggingThing x=3 y=4 z=5] someAA otherBB";
        Assert.assertEquals((Object)"DEBUG org.apache.logging.log4j.core.impl.NestedLoggingFromToStringTest.ParameterizedLoggingThing getX: values x=3 y=4 z=5", (Object)list.get(0));
        Assert.assertEquals((Object)"INFO org.apache.logging.log4j.core.impl.NestedLoggingFromToStringTest next: it=[ParameterizedLoggingThing x=3 y=4 z=5] someAA otherBB", (Object)list.get(1));
    }

    @Test
    public void testDoublyNestedLogging() {
        this.logger.info((Object)new ObjectLoggingThing1());
        List<String> list = this.listAppender.getMessages();
        String expect1 = "DEBUG org.apache.logging.log4j.core.impl.NestedLoggingFromToStringTest.ParameterizedLoggingThing getX: values x=3 y=4 z=5";
        String expect2 = "TRACE org.apache.logging.log4j.core.impl.NestedLoggingFromToStringTest.ObjectLoggingThing2 [ParameterizedLoggingThing x=3 y=4 z=5]";
        String expect3 = "TRACE org.apache.logging.log4j.core.impl.NestedLoggingFromToStringTest.ObjectLoggingThing1 [ObjectLoggingThing2 x=123]";
        String expect4 = "INFO org.apache.logging.log4j.core.impl.NestedLoggingFromToStringTest [ObjectLoggingThing1 y=999]";
        Assert.assertEquals((Object)"DEBUG org.apache.logging.log4j.core.impl.NestedLoggingFromToStringTest.ParameterizedLoggingThing getX: values x=3 y=4 z=5", (Object)list.get(0));
        Assert.assertEquals((Object)"TRACE org.apache.logging.log4j.core.impl.NestedLoggingFromToStringTest.ObjectLoggingThing2 [ParameterizedLoggingThing x=3 y=4 z=5]", (Object)list.get(1));
        Assert.assertEquals((Object)"TRACE org.apache.logging.log4j.core.impl.NestedLoggingFromToStringTest.ObjectLoggingThing1 [ObjectLoggingThing2 x=123]", (Object)list.get(2));
        Assert.assertEquals((Object)"INFO org.apache.logging.log4j.core.impl.NestedLoggingFromToStringTest [ObjectLoggingThing1 y=999]", (Object)list.get(3));
    }

    static class ObjectLoggingThing2 {
        final Logger innerLogger = LogManager.getLogger(ObjectLoggingThing2.class);

        ObjectLoggingThing2() {
        }

        public int getX() {
            this.innerLogger.trace((Object)new ParameterizedLoggingThing());
            return 123;
        }

        public String toString() {
            return "[" + this.getClass().getSimpleName() + " x=" + this.getX() + "]";
        }
    }

    static class ObjectLoggingThing1 {
        final Logger innerLogger = LogManager.getLogger(ObjectLoggingThing1.class);

        ObjectLoggingThing1() {
        }

        public int getX() {
            this.innerLogger.trace((Object)new ObjectLoggingThing2());
            return 999;
        }

        public String toString() {
            return "[" + this.getClass().getSimpleName() + " y=" + this.getX() + "]";
        }
    }

    static class ParameterizedLoggingThing {
        final Logger innerLogger = LogManager.getLogger(ParameterizedLoggingThing.class);
        private final int x = 3;
        private final int y = 4;
        private final int z = 5;

        ParameterizedLoggingThing() {
        }

        public int getX() {
            this.innerLogger.debug("getX: values x={} y={} z={}", (Object)3, (Object)4, (Object)5);
            return 3;
        }

        public String toString() {
            return "[" + this.getClass().getSimpleName() + " x=" + this.getX() + " y=" + 4 + " z=" + 5 + "]";
        }
    }
}

