/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.appender.rolling.action;

import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.logging.log4j.core.appender.rolling.action.DeletingVisitor;
import org.apache.logging.log4j.core.appender.rolling.action.FixedCondition;
import org.apache.logging.log4j.core.appender.rolling.action.PathCondition;
import org.junit.Assert;
import org.junit.Test;

public class DeletingVisitorTest {
    @Test
    public void testAcceptedFilesAreDeleted() throws IOException {
        Path base = Paths.get("/a/b/c", new String[0]);
        FixedCondition ACCEPT_ALL = new FixedCondition(true);
        DeletingVisitorHelper visitor = new DeletingVisitorHelper(base, Arrays.asList(ACCEPT_ALL), false);
        Path any = Paths.get("/a/b/c/any", new String[0]);
        visitor.visitFile(any, null);
        Assert.assertTrue((boolean)visitor.deleted.contains(any));
    }

    @Test
    public void testRejectedFilesAreNotDeleted() throws IOException {
        Path base = Paths.get("/a/b/c", new String[0]);
        FixedCondition REJECT_ALL = new FixedCondition(false);
        DeletingVisitorHelper visitor = new DeletingVisitorHelper(base, Arrays.asList(REJECT_ALL), false);
        Path any = Paths.get("/a/b/c/any", new String[0]);
        visitor.visitFile(any, null);
        Assert.assertFalse((boolean)visitor.deleted.contains(any));
    }

    @Test
    public void testAllFiltersMustAcceptOrFileIsNotDeleted() throws IOException {
        Path base = Paths.get("/a/b/c", new String[0]);
        FixedCondition ACCEPT_ALL = new FixedCondition(true);
        FixedCondition REJECT_ALL = new FixedCondition(false);
        List<FixedCondition> filters = Arrays.asList(ACCEPT_ALL, ACCEPT_ALL, REJECT_ALL);
        DeletingVisitorHelper visitor = new DeletingVisitorHelper(base, filters, false);
        Path any = Paths.get("/a/b/c/any", new String[0]);
        visitor.visitFile(any, null);
        Assert.assertFalse((boolean)visitor.deleted.contains(any));
    }

    @Test
    public void testIfAllFiltersAcceptFileIsDeleted() throws IOException {
        Path base = Paths.get("/a/b/c", new String[0]);
        FixedCondition ACCEPT_ALL = new FixedCondition(true);
        List<FixedCondition> filters = Arrays.asList(ACCEPT_ALL, ACCEPT_ALL, ACCEPT_ALL);
        DeletingVisitorHelper visitor = new DeletingVisitorHelper(base, filters, false);
        Path any = Paths.get("/a/b/c/any", new String[0]);
        visitor.visitFile(any, null);
        Assert.assertTrue((boolean)visitor.deleted.contains(any));
    }

    @Test
    public void testInTestModeFileIsNotDeletedEvenIfAllFiltersAccept() throws IOException {
        Path base = Paths.get("/a/b/c", new String[0]);
        FixedCondition ACCEPT_ALL = new FixedCondition(true);
        List<FixedCondition> filters = Arrays.asList(ACCEPT_ALL, ACCEPT_ALL, ACCEPT_ALL);
        DeletingVisitorHelper visitor = new DeletingVisitorHelper(base, filters, true);
        Path any = Paths.get("/a/b/c/any", new String[0]);
        visitor.visitFile(any, null);
        Assert.assertFalse((boolean)visitor.deleted.contains(any));
    }

    @Test
    public void testVisitFileRelativizesAgainstBase() throws IOException {
        PathCondition filter = new PathCondition(){

            public boolean accept(Path baseDir, Path relativePath, BasicFileAttributes attrs) {
                Path expected = Paths.get("relative", new String[0]);
                Assert.assertEquals((Object)expected, (Object)relativePath);
                return true;
            }

            public void beforeFileTreeWalk() {
            }
        };
        Path base = Paths.get("/a/b/c", new String[0]);
        DeletingVisitorHelper visitor = new DeletingVisitorHelper(base, Arrays.asList(filter), false);
        Path child = Paths.get("/a/b/c/relative", new String[0]);
        visitor.visitFile(child, null);
    }

    @Test
    public void testNoSuchFileFailure() throws IOException {
        DeletingVisitorHelper visitor = new DeletingVisitorHelper(Paths.get("/a/b/c", new String[0]), Collections.emptyList(), true);
        Assert.assertEquals((Object)((Object)FileVisitResult.CONTINUE), (Object)((Object)visitor.visitFileFailed(Paths.get("doesNotExist", new String[0]), new NoSuchFileException("doesNotExist"))));
    }

    @Test
    public void testIOException() {
        DeletingVisitorHelper visitor = new DeletingVisitorHelper(Paths.get("/a/b/c", new String[0]), Collections.emptyList(), true);
        IOException exception = new IOException();
        try {
            visitor.visitFileFailed(Paths.get("doesNotExist", new String[0]), exception);
            Assert.fail();
        }
        catch (IOException e) {
            Assert.assertSame((Object)exception, (Object)e);
        }
    }

    static class DeletingVisitorHelper
    extends DeletingVisitor {
        List<Path> deleted = new ArrayList<Path>();

        public DeletingVisitorHelper(Path basePath, List<? extends PathCondition> pathFilters, boolean testMode) {
            super(basePath, pathFilters, testMode);
        }

        protected void delete(Path file) throws IOException {
            this.deleted.add(file);
        }
    }
}

