/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.appender.rolling;

import java.util.regex.Matcher;
import org.apache.logging.log4j.core.appender.rolling.AbstractRolloverStrategy;
import org.junit.Assert;
import org.junit.Test;

public class RolloverFilePatternTest {
    @Test
    public void testFilePatternWithoutPadding() throws Exception {
        Matcher matcher = AbstractRolloverStrategy.PATTERN_COUNTER.matcher("target/logs/test-%i.log.gz");
        Assert.assertTrue((boolean)matcher.matches());
        Assert.assertNull((Object)matcher.group("ZEROPAD"));
        Assert.assertNull((Object)matcher.group("PADDING"));
    }

    @Test
    public void testFilePatternWithSpacePadding() throws Exception {
        Matcher matcher = AbstractRolloverStrategy.PATTERN_COUNTER.matcher("target/logs/test-%3i.log.gz");
        Assert.assertTrue((boolean)matcher.matches());
        Assert.assertNull((Object)matcher.group("ZEROPAD"));
        Assert.assertEquals((Object)"3", (Object)matcher.group("PADDING"));
    }

    @Test
    public void testFilePatternWithZeroPadding() throws Exception {
        Matcher matcher = AbstractRolloverStrategy.PATTERN_COUNTER.matcher("target/logs/test-%03i.log.gz");
        Assert.assertTrue((boolean)matcher.matches());
        Assert.assertEquals((Object)"0", (Object)matcher.group("ZEROPAD"));
        Assert.assertEquals((Object)"3", (Object)matcher.group("PADDING"));
    }

    @Test
    public void testFilePatternUnmatched() throws Exception {
        Matcher matcher = AbstractRolloverStrategy.PATTERN_COUNTER.matcher("target/logs/test-%n.log.gz");
        Assert.assertFalse((boolean)matcher.matches());
    }
}

