/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.appender.rolling;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.BasicFileAttributeView;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import org.apache.logging.log4j.core.Logger;
import org.apache.logging.log4j.hamcrest.Descriptors;
import org.apache.logging.log4j.hamcrest.FileMatchers;
import org.apache.logging.log4j.junit.LoggerContextRule;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;

public class RollingAppenderRestartTest {
    private static final String CONFIG = "log4j-rolling-restart.xml";
    private static final String DIR = "target/rolling-restart";
    private final LoggerContextRule loggerContextRule = LoggerContextRule.createShutdownTimeoutLoggerContextRule("log4j-rolling-restart.xml");
    @Rule
    public RuleChain chain = this.loggerContextRule.withCleanFoldersRule(false, true, 5, "target/rolling-restart");

    @BeforeClass
    public static void setup() throws Exception {
        File file = new File("target/rolling-restart/test.log");
        Files.createDirectories(file.toPath().getParent(), new FileAttribute[0]);
        Files.write(file.toPath(), "Hello, world".getBytes(), StandardOpenOption.CREATE);
        FileTime newTime = FileTime.from(Instant.now().minus(2L, ChronoUnit.DAYS));
        Files.getFileAttributeView(file.toPath(), BasicFileAttributeView.class, new LinkOption[0]).setTimes(newTime, newTime, newTime);
    }

    @Test
    public void testAppender() throws Exception {
        Logger logger = this.loggerContextRule.getLogger();
        logger.info("This is test message number 1");
        File dir = new File(DIR);
        Matcher hasGzippedFile = Matchers.hasItemInArray(Descriptors.that(FileMatchers.hasName(Descriptors.that(Matchers.endsWith((String)".gz")))));
        File[] files = dir.listFiles();
        Assert.assertTrue((String)"No gzipped files found", (boolean)hasGzippedFile.matches((Object)files));
    }
}

