/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.appender.rewrite;

import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.EventLogger;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.junit.LoggerContextRule;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.StructuredDataMessage;
import org.apache.logging.log4j.test.appender.ListAppender;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;

public class RewriteAppenderTest {
    private ListAppender app;
    private ListAppender app2;
    @ClassRule
    public static LoggerContextRule init = new LoggerContextRule("log4j-rewrite.xml");

    @Before
    public void setUp() throws Exception {
        this.app = init.getListAppender("List");
        this.app2 = init.getListAppender("List2");
    }

    @After
    public void tearDown() throws Exception {
        if (this.app != null) {
            this.app.clear();
        }
        if (this.app2 != null) {
            this.app2.clear();
        }
    }

    @Test
    public void rewriteTest() {
        StructuredDataMessage msg = new StructuredDataMessage("Test", "This is a test", "Service");
        msg.put("Key1", "Value1");
        msg.put("Key2", "Value2");
        EventLogger.logEvent((StructuredDataMessage)msg);
        List<LogEvent> list = this.app.getEvents();
        Assert.assertNotNull((String)"No events generated", list);
        Assert.assertTrue((String)("Incorrect number of events. Expected 1, got " + list.size()), (list.size() == 1 ? 1 : 0) != 0);
        LogEvent event = list.get(0);
        Message m = event.getMessage();
        Assert.assertTrue((String)("Message is not a StringMapMessage: " + m.getClass()), (boolean)(m instanceof StructuredDataMessage));
        StructuredDataMessage message = (StructuredDataMessage)m;
        Map map = message.getData();
        Assert.assertNotNull((String)"No Map", (Object)map);
        Assert.assertTrue((String)("Incorrect number of map entries, expected 3 got " + map.size()), (map.size() == 3 ? 1 : 0) != 0);
        String value = (String)map.get("Key1");
        Assert.assertEquals((Object)"Apache", (Object)value);
    }

    @Test
    public void testProperties() {
        Logger logger = LogManager.getLogger(RewriteAppenderTest.class);
        logger.debug("Test properties rewrite");
        List<String> list = this.app2.getMessages();
        Assert.assertNotNull((String)"No events generated", list);
        Assert.assertTrue((String)("Incorrect number of events. Expected 1, got " + list.size()), (list.size() == 1 ? 1 : 0) != 0);
        Assert.assertFalse((String)"Did not resolve user name", (boolean)list.get(0).contains("{user.dir}"));
    }

    @Test
    public void testFilter() {
        StructuredDataMessage msg = new StructuredDataMessage("Test", "This is a test", "Service");
        msg.put("Key1", "Value2");
        msg.put("Key2", "Value1");
        Logger logger = LogManager.getLogger((String)"org.apache.logging.log4j.core.Logging");
        logger.debug((Message)msg);
        msg = new StructuredDataMessage("Test", "This is a test", "Service");
        msg.put("Key1", "Value1");
        msg.put("Key2", "Value2");
        logger.trace((Message)msg);
        List<LogEvent> list = this.app.getEvents();
        Assert.assertTrue((String)"Events were generated", (list == null || list.isEmpty() ? 1 : 0) != 0);
    }
}

