/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.appender.db.jdbc;

import java.io.ByteArrayOutputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.appender.db.jdbc.JdbcH2TestHelper;
import org.apache.logging.log4j.junit.JdbcRule;
import org.apache.logging.log4j.junit.LoggerContextRule;
import org.apache.logging.log4j.test.RuleChainFactory;
import org.h2.util.IOUtils;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;

public class JdbcAppenderColumnMappingLiteralTest {
    @Rule
    public final RuleChain rules;
    private final JdbcRule jdbcRule;

    public JdbcAppenderColumnMappingLiteralTest() {
        this(new JdbcRule(JdbcH2TestHelper.TEST_CONFIGURATION_SOURCE_TMPDIR, "CREATE TABLE dsMappingLogEntry (id INTEGER IDENTITY, level VARCHAR(10), logger VARCHAR(255), message VARCHAR(1024), exception CLOB)", "DROP TABLE dsMappingLogEntry"));
    }

    protected JdbcAppenderColumnMappingLiteralTest(JdbcRule jdbcRule) {
        this.rules = RuleChainFactory.create(jdbcRule, new LoggerContextRule("org/apache/logging/log4j/core/appender/db/jdbc/log4j2-dm-column-mapping-literal.xml"));
        this.jdbcRule = jdbcRule;
    }

    @Test
    public void test() throws Exception {
        try (Connection connection = this.jdbcRule.getConnection();){
            Error exception = new Error("This is a test.");
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            try (PrintWriter writer = new PrintWriter(outputStream);){
                exception.printStackTrace(writer);
            }
            String stackTrace = outputStream.toString();
            Logger logger = LogManager.getLogger((String)(this.getClass().getName() + ".testDataSourceConfig"));
            logger.trace("Data source logged message 01.");
            logger.fatal("Error from data source 02.", (Throwable)exception);
            Thread.sleep(1000L);
            try (Statement statement = connection.createStatement();
                 ResultSet resultSet = statement.executeQuery("SELECT * FROM dsMappingLogEntry ORDER BY id");){
                Assert.assertTrue((String)"There should be at least one row.", (boolean)resultSet.next());
                Assert.assertEquals((String)"The level column is not correct (1).", (Object)"FATAL", (Object)resultSet.getNString("level"));
                Assert.assertEquals((String)"The logger column is not correct (1).", (Object)logger.getName(), (Object)resultSet.getNString("logger"));
                Assert.assertEquals((String)"The message column is not correct (1).", (Object)"Hello World!", (Object)resultSet.getString("message"));
                Assert.assertEquals((String)"The exception column is not correct (1).", (Object)stackTrace, (Object)IOUtils.readStringAndClose((Reader)resultSet.getNClob("exception").getCharacterStream(), (int)-1));
                Assert.assertFalse((String)"There should not be two rows.", (boolean)resultSet.next());
            }
        }
    }
}

