/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.appender;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.PosixFileAttributes;
import java.nio.file.attribute.PosixFilePermissions;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.SystemUtils;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.appender.FileAppender;
import org.apache.logging.log4j.core.impl.Log4jLogEvent;
import org.apache.logging.log4j.core.layout.PatternLayout;
import org.apache.logging.log4j.core.util.FileUtils;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.SimpleMessage;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class FileAppenderPermissionsTest {
    private static final String DIR = "target/permissions1";
    private final boolean createOnDemand;
    private final String filePermissions;
    private final int fileIndex;

    @Parameterized.Parameters(name="{0} {1} {2}")
    public static Collection<Object[]> data() throws IOException {
        return Arrays.asList({"rwxrwxrwx", true, 2}, {"rw-r--r--", false, 3}, {"rw-------", true, 4}, {"rw-rw----", false, 5});
    }

    public FileAppenderPermissionsTest(String filePermissions, boolean createOnDemand, int fileIndex) {
        this.filePermissions = filePermissions;
        this.createOnDemand = createOnDemand;
        this.fileIndex = fileIndex;
    }

    @BeforeClass
    public static void beforeClass() {
        System.setProperty("log4j2.debug", "true");
        Assume.assumeTrue((boolean)FileUtils.isFilePosixAttributeViewSupported());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFilePermissionsAPI() throws Exception {
        File file = new File(DIR, "AppenderTest-" + this.fileIndex + ".log");
        Path path = file.toPath();
        PatternLayout layout = PatternLayout.newBuilder().withPattern("%d [%t] %p %c - %m%n").build();
        FileAppender appender = ((FileAppender.Builder)((FileAppender.Builder)((FileAppender.Builder)((FileAppender.Builder)((FileAppender.Builder)((FileAppender.Builder)FileAppender.newBuilder().withFileName(file.getAbsolutePath()).setName("test")).withImmediateFlush(false)).setIgnoreExceptions(false)).withBufferedIo(false)).withBufferSize(1)).setLayout((Layout)layout)).withCreateOnDemand(this.createOnDemand).withFilePermissions(this.filePermissions).build();
        try {
            long curLen;
            appender.start();
            Assert.assertTrue((String)"Appender did not start", (boolean)appender.isStarted());
            Assert.assertNotEquals((Object)this.createOnDemand, (Object)Files.exists(path, new LinkOption[0]));
            long prevLen = curLen = file.length();
            Assert.assertTrue((String)("File length: " + curLen), (curLen == 0L ? 1 : 0) != 0);
            for (int i = 0; i < 100; ++i) {
                Log4jLogEvent event = Log4jLogEvent.newBuilder().setLoggerName("TestLogger").setLoggerFqcn(FileAppenderPermissionsTest.class.getName()).setLevel(Level.INFO).setMessage((Message)new SimpleMessage("Test")).setThreadName(this.getClass().getSimpleName()).setTimeMillis(System.currentTimeMillis()).build();
                appender.append((LogEvent)event);
                curLen = file.length();
                Assert.assertTrue((String)("File length: " + curLen), (curLen > prevLen ? 1 : 0) != 0);
                Thread.sleep(25L);
                prevLen = curLen;
            }
            Assert.assertEquals((Object)this.filePermissions, (Object)PosixFilePermissions.toString(Files.getPosixFilePermissions(path, new LinkOption[0])));
        }
        finally {
            appender.stop();
            Files.deleteIfExists(path);
        }
        Assert.assertFalse((String)"Appender did not stop", (boolean)appender.isStarted());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFileUserGroupAPI() throws Exception {
        File file = new File(DIR, "AppenderTest-" + (1000 + this.fileIndex) + ".log");
        Path path = file.toPath();
        String user = FileAppenderPermissionsTest.findAUser();
        Assert.assertNotNull((Object)user);
        String group = FileAppenderPermissionsTest.findAGroup(user);
        Assert.assertNotNull((Object)group);
        PatternLayout layout = PatternLayout.newBuilder().withPattern("%d [%t] %p %c - %m%n").build();
        FileAppender appender = ((FileAppender.Builder)((FileAppender.Builder)((FileAppender.Builder)((FileAppender.Builder)((FileAppender.Builder)((FileAppender.Builder)FileAppender.newBuilder().withFileName(file.getAbsolutePath()).setName("test")).withImmediateFlush(true)).setIgnoreExceptions(false)).withBufferedIo(false)).withBufferSize(1)).setLayout((Layout)layout)).withFilePermissions(this.filePermissions).withFileOwner(user).withFileGroup(group).build();
        try {
            long curLen;
            appender.start();
            Assert.assertTrue((String)"Appender did not start", (boolean)appender.isStarted());
            long prevLen = curLen = file.length();
            Assert.assertTrue((String)(file + " File length: " + curLen), (curLen == 0L ? 1 : 0) != 0);
            for (int i = 0; i < 100; ++i) {
                Log4jLogEvent event = Log4jLogEvent.newBuilder().setLoggerName("TestLogger").setLoggerFqcn(FileAppenderPermissionsTest.class.getName()).setLevel(Level.INFO).setMessage((Message)new SimpleMessage("Test")).setThreadName(this.getClass().getSimpleName()).setTimeMillis(System.currentTimeMillis()).build();
                appender.append((LogEvent)event);
                curLen = file.length();
                Assert.assertTrue((String)("File length: " + curLen), (curLen > prevLen ? 1 : 0) != 0);
                Thread.sleep(25L);
                prevLen = curLen;
            }
            Assert.assertEquals((Object)this.filePermissions, (Object)PosixFilePermissions.toString(Files.getPosixFilePermissions(path, new LinkOption[0])));
            Assert.assertEquals((Object)user, (Object)Files.getOwner(path, new LinkOption[0]).getName());
            Assert.assertEquals((Object)group, (Object)Files.readAttributes(path, PosixFileAttributes.class, new LinkOption[0]).group().getName());
        }
        finally {
            appender.stop();
            Files.deleteIfExists(path);
        }
        Assert.assertFalse((String)"Appender did not stop", (boolean)appender.isStarted());
    }

    public static String findAGroup(String user) throws IOException {
        if (SystemUtils.IS_OS_MAC_OSX) {
            return "staff";
        }
        String group = user;
        try (FileInputStream fis = new FileInputStream("/etc/group");){
            List groups = IOUtils.readLines((InputStream)fis, (Charset)Charset.defaultCharset());
            for (int i = 0; i < groups.size(); ++i) {
                String aGroup = (String)groups.get(i);
                if (aGroup.startsWith(user) || !aGroup.contains(user)) continue;
                group = aGroup.split(":")[0];
                break;
            }
        }
        return group;
    }

    private static String findAUser() throws IOException {
        return System.getProperty("user.name");
    }
}

