/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core;

import java.util.Date;
import java.util.List;
import java.util.Locale;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.MarkerManager;
import org.apache.logging.log4j.ThreadContext;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.junit.LoggerContextRule;
import org.apache.logging.log4j.message.EntryMessage;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.StructuredDataMessage;
import org.apache.logging.log4j.test.appender.ListAppender;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;

public class StrictXmlConfigTest {
    private static final String CONFIG = "log4j-strict1.xml";
    private ListAppender app;
    @ClassRule
    public static LoggerContextRule context = new LoggerContextRule("log4j-strict1.xml");
    Logger logger = context.getLogger("LoggerTest");

    @Before
    public void setUp() throws Exception {
        this.app = context.getListAppender("List").clear();
    }

    @Test
    public void basicFlow() {
        EntryMessage entry = this.logger.traceEntry();
        this.logger.traceExit(entry);
        List<LogEvent> events = this.app.getEvents();
        Assert.assertEquals((String)("Incorrect number of events. Expected 2, actual " + events.size()), (long)2L, (long)events.size());
    }

    @Test
    public void basicFlowDeprecated() {
        this.logger.traceEntry();
        this.logger.traceExit();
        List<LogEvent> events = this.app.getEvents();
        Assert.assertEquals((String)("Incorrect number of events. Expected 2, actual " + events.size()), (long)2L, (long)events.size());
    }

    @Test
    public void simpleFlow() {
        this.logger.entry(new Object[]{CONFIG});
        this.logger.exit((Object)0);
        List<LogEvent> events = this.app.getEvents();
        Assert.assertEquals((String)("Incorrect number of events. Expected 2, actual " + events.size()), (long)2L, (long)events.size());
    }

    @Test
    public void throwing() {
        this.logger.throwing((Throwable)new IllegalArgumentException("Test Exception"));
        List<LogEvent> events = this.app.getEvents();
        Assert.assertEquals((String)("Incorrect number of events. Expected 1, actual " + events.size()), (long)1L, (long)events.size());
    }

    @Test
    public void catching() {
        try {
            throw new NullPointerException();
        }
        catch (Exception e) {
            this.logger.catching((Throwable)e);
            List<LogEvent> events = this.app.getEvents();
            Assert.assertEquals((String)("Incorrect number of events. Expected 1, actual " + events.size()), (long)1L, (long)events.size());
            return;
        }
    }

    @Test
    public void debug() {
        this.logger.debug("Debug message");
        List<LogEvent> events = this.app.getEvents();
        Assert.assertEquals((String)("Incorrect number of events. Expected 1, actual " + events.size()), (long)1L, (long)events.size());
    }

    @Test
    public void debugObject() {
        this.logger.debug((Object)new Date());
        List<LogEvent> events = this.app.getEvents();
        Assert.assertEquals((String)("Incorrect number of events. Expected 1, actual " + events.size()), (long)1L, (long)events.size());
    }

    @Test
    public void debugWithParms() {
        this.logger.debug("Hello, {}", (Object)"World");
        List<LogEvent> events = this.app.getEvents();
        Assert.assertEquals((String)("Incorrect number of events. Expected 1, actual " + events.size()), (long)1L, (long)events.size());
    }

    @Test
    public void mdc() {
        ThreadContext.put((String)"TestYear", (String)"2010");
        this.logger.debug("Debug message");
        ThreadContext.clearMap();
        this.logger.debug("Debug message");
        List<LogEvent> events = this.app.getEvents();
        Assert.assertEquals((String)("Incorrect number of events. Expected 2, actual " + events.size()), (long)2L, (long)events.size());
    }

    @Test
    public void structuredData() {
        ThreadContext.put((String)"loginId", (String)"JohnDoe");
        ThreadContext.put((String)"ipAddress", (String)"192.168.0.120");
        ThreadContext.put((String)"locale", (String)Locale.US.getDisplayName());
        StructuredDataMessage msg = new StructuredDataMessage("Audit@18060", "Transfer Complete", "Transfer");
        msg.put("ToAccount", "123456");
        msg.put("FromAccount", "123457");
        msg.put("Amount", "200.00");
        this.logger.info(MarkerManager.getMarker((String)"EVENT"), (Message)msg);
        ThreadContext.clearMap();
        List<LogEvent> events = this.app.getEvents();
        Assert.assertEquals((String)("Incorrect number of events. Expected 1, actual " + events.size()), (long)1L, (long)events.size());
    }
}

