/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core;

import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;
import org.apache.logging.log4j.categories.Configurations;
import org.apache.logging.log4j.junit.LoggerContextRule;
import org.apache.logging.log4j.test.appender.ListAppender;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={Configurations.Json.class})
public class AppenderRefLevelJsonTest {
    private static final String CONFIG = "log4j-reference-level.json";
    private ListAppender app1;
    private ListAppender app2;
    @ClassRule
    public static LoggerContextRule context = new LoggerContextRule("log4j-reference-level.json");
    Logger logger1 = context.getLogger("org.apache.logging.log4j.test1");
    Logger logger2 = context.getLogger("org.apache.logging.log4j.test2");
    Logger logger3 = context.getLogger("org.apache.logging.log4j.test3");
    Marker testMarker = MarkerManager.getMarker((String)"TEST");

    @Before
    public void before() {
        this.app1 = context.getListAppender("LIST1").clear();
        this.app2 = context.getListAppender("LIST2").clear();
    }

    @Test
    public void logger1() {
        this.logger1.traceEntry();
        this.logger1.debug("debug message");
        this.logger1.error("Test Message");
        this.logger1.info("Info Message");
        this.logger1.warn("warn Message");
        this.logger1.traceExit();
        Assert.assertThat(this.app1.getEvents(), (Matcher)Matchers.hasSize((int)6));
        Assert.assertThat(this.app2.getEvents(), (Matcher)Matchers.hasSize((int)1));
    }

    @Test
    public void logger2() {
        this.logger2.traceEntry();
        this.logger2.debug("debug message");
        this.logger2.error("Test Message");
        this.logger2.info("Info Message");
        this.logger2.warn("warn Message");
        this.logger2.traceExit();
        Assert.assertThat(this.app1.getEvents(), (Matcher)Matchers.hasSize((int)2));
        Assert.assertThat(this.app2.getEvents(), (Matcher)Matchers.hasSize((int)4));
    }

    @Test
    public void logger3() {
        this.logger3.traceEntry();
        this.logger3.debug(this.testMarker, "debug message");
        this.logger3.error("Test Message");
        this.logger3.info(this.testMarker, "Info Message");
        this.logger3.warn("warn Message");
        this.logger3.traceExit();
        Assert.assertThat(this.app1.getEvents(), (Matcher)Matchers.hasSize((int)4));
    }
}

