/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.junit;

import java.util.Collections;
import java.util.Map;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;
import org.springframework.mock.jndi.SimpleNamingContextBuilder;

public class JndiRule
implements TestRule {
    private final Map<String, Object> initialBindings;

    public JndiRule(String name, Object value) {
        this.initialBindings = Collections.singletonMap(name, value);
    }

    public JndiRule(Map<String, Object> initialBindings) {
        this.initialBindings = initialBindings;
    }

    public Statement apply(final Statement base, Description description) {
        return new Statement(){

            public void evaluate() throws Throwable {
                SimpleNamingContextBuilder builder = SimpleNamingContextBuilder.emptyActivatedContextBuilder();
                for (Map.Entry entry : JndiRule.this.initialBindings.entrySet()) {
                    builder.bind((String)entry.getKey(), entry.getValue());
                }
                base.evaluate();
            }
        };
    }
}

