/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.hamcrest;

import java.io.File;
import org.hamcrest.FeatureMatcher;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsEqual;
import org.hamcrest.number.OrderingComparison;

public final class FileMatchers {
    public static Matcher<File> exists() {
        return new FeatureMatcher<File, Boolean>(Is.is((Object)true), "file exists", "file exists"){

            protected Boolean featureValueOf(File actual) {
                return actual.exists();
            }
        };
    }

    public static Matcher<File> hasLength(Matcher<Long> matcher) {
        return new FeatureMatcher<File, Long>(matcher, "file with size", "file with size"){

            protected Long featureValueOf(File actual) {
                return actual.length();
            }
        };
    }

    public static <T extends Number> Matcher<File> hasLength(T length) {
        return FileMatchers.hasLength(IsEqual.equalTo((Object)length.longValue()));
    }

    public static Matcher<File> hasLength(long length) {
        return FileMatchers.hasLength(IsEqual.equalTo((Object)length));
    }

    public static Matcher<File> isEmpty() {
        return FileMatchers.hasLength(0L);
    }

    public static Matcher<File> lastModified(Matcher<Long> matcher) {
        return new FeatureMatcher<File, Long>(matcher, "was last modified", "was last modified"){

            protected Long featureValueOf(File actual) {
                return actual.lastModified();
            }
        };
    }

    public static Matcher<Long> beforeNow() {
        return OrderingComparison.lessThanOrEqualTo((Comparable)Long.valueOf(System.currentTimeMillis()));
    }

    public static Matcher<File> hasNumberOfFiles(Matcher<Integer> matcher) {
        return new FeatureMatcher<File, Integer>(matcher, "directory with number of files", "directory with number of files"){

            protected Integer featureValueOf(File actual) {
                File[] files = actual.listFiles();
                return files == null ? 0 : files.length;
            }
        };
    }

    public static Matcher<File> hasFiles() {
        return FileMatchers.hasNumberOfFiles((Matcher<Integer>)OrderingComparison.greaterThan((Comparable)Integer.valueOf(0)));
    }

    public static Matcher<File> hasName(Matcher<String> matcher) {
        return new FeatureMatcher<File, String>(matcher, "file named", "file named"){

            protected String featureValueOf(File actual) {
                return actual.getName();
            }
        };
    }

    private FileMatchers() {
    }
}

