/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.lookup;

import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.impl.Log4jLogEvent;
import org.apache.logging.log4j.core.lookup.EventLookup;
import org.apache.logging.log4j.core.lookup.StrLookup;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.SimpleMessage;
import org.junit.Assert;
import org.junit.Test;

public class EventLookupTest {
    private static final String ABSENT_MARKER_NAME = "NONE";
    private final String markerName = "EventLookupTest";
    private final StrLookup strLookup = new EventLookup();

    @Test
    public void testLookupEventMarker() {
        Marker marker = MarkerManager.getMarker((String)"EventLookupTest");
        Log4jLogEvent event = Log4jLogEvent.newBuilder().setLoggerName(this.getClass().getName()).setMarker(marker).setLoggerFqcn("org.apache.logging.log4j.core.Logger").setLevel(Level.INFO).setMessage((Message)new SimpleMessage("Hello, world!")).build();
        String value = this.strLookup.lookup((LogEvent)event, "Marker");
        Assert.assertEquals((Object)"EventLookupTest", (Object)value);
    }

    @Test
    public void testLookupEventMessage() {
        String msg = "Hello, world!";
        Log4jLogEvent event = Log4jLogEvent.newBuilder().setLoggerName(this.getClass().getName()).setLoggerFqcn("org.apache.logging.log4j.core.Logger").setLevel(Level.INFO).setMessage((Message)new SimpleMessage(msg)).build();
        String value = this.strLookup.lookup((LogEvent)event, "Message");
        Assert.assertEquals((Object)msg, (Object)value);
    }

    @Test
    public void testLookupEventLevel() {
        String msg = "Hello, world!";
        Log4jLogEvent event = Log4jLogEvent.newBuilder().setLoggerName(this.getClass().getName()).setLoggerFqcn("org.apache.logging.log4j.core.Logger").setLevel(Level.INFO).setMessage((Message)new SimpleMessage(msg)).build();
        String value = this.strLookup.lookup((LogEvent)event, "Level");
        Assert.assertEquals((Object)Level.INFO.toString(), (Object)value);
    }

    @Test
    public void testLookupEventTimestamp() {
        String msg = "Hello, world!";
        long now = System.currentTimeMillis();
        Log4jLogEvent event = Log4jLogEvent.newBuilder().setLoggerName(this.getClass().getName()).setTimeMillis(now).setLoggerFqcn("org.apache.logging.log4j.core.Logger").setLevel(Level.INFO).setMessage((Message)new SimpleMessage(msg)).build();
        String value = this.strLookup.lookup((LogEvent)event, "Timestamp");
        Assert.assertEquals((Object)Long.toString(now), (Object)value);
    }

    @Test
    public void testLookupEventLogger() {
        String msg = "Hello, world!";
        Log4jLogEvent event = Log4jLogEvent.newBuilder().setLoggerName(this.getClass().getName()).setLoggerFqcn("org.apache.logging.log4j.core.Logger").setLevel(Level.INFO).setMessage((Message)new SimpleMessage(msg)).build();
        String value = this.strLookup.lookup((LogEvent)event, "Logger");
        Assert.assertEquals((Object)this.getClass().getName(), (Object)value);
    }

    @Test
    public void testLookupEventThreadName() {
        String msg = "Hello, world!";
        Log4jLogEvent event = Log4jLogEvent.newBuilder().setLoggerName(this.getClass().getName()).setThreadName("Main").setLoggerFqcn("org.apache.logging.log4j.core.Logger").setLevel(Level.INFO).setMessage((Message)new SimpleMessage(msg)).build();
        String value = this.strLookup.lookup((LogEvent)event, "ThreadName");
        Assert.assertEquals((Object)"Main", (Object)value);
    }
}

