/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.layout;

import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.logging.log4j.core.layout.ByteBufferDestination;
import org.apache.logging.log4j.core.layout.SpyByteBufferDestination;
import org.apache.logging.log4j.core.layout.StringBuilderEncoder;
import org.apache.logging.log4j.core.layout.TextEncoderHelper;
import org.junit.Assert;
import org.junit.Test;

public class StringBuilderEncoderTest {
    @Test
    public void testEncodeText_TextFitCharBuff_BytesFitByteBuff() throws Exception {
        StringBuilderEncoder helper = new StringBuilderEncoder(StandardCharsets.UTF_8, 16, 8192);
        StringBuilder text = this.createText(15);
        SpyByteBufferDestination destination = new SpyByteBufferDestination(17, 17);
        helper.encode(text, (ByteBufferDestination)destination);
        Assert.assertEquals((String)"drained", (long)0L, (long)destination.drainPoints.size());
        Assert.assertEquals((String)"destination.buf.pos", (long)text.length(), (long)destination.buffer.position());
        for (int i = 0; i < text.length(); ++i) {
            Assert.assertEquals((String)("char at " + i), (long)((byte)text.charAt(i)), (long)destination.buffer.get(i));
        }
    }

    @Test
    public void testEncodeText_TextFitCharBuff_BytesDontFitByteBuff() throws Exception {
        int i;
        StringBuilderEncoder helper = new StringBuilderEncoder(StandardCharsets.UTF_8, 16, 8192);
        StringBuilder text = this.createText(15);
        SpyByteBufferDestination destination = new SpyByteBufferDestination(14, 15);
        helper.encode(text, (ByteBufferDestination)destination);
        Assert.assertEquals((String)"drained", (long)1L, (long)destination.drainPoints.size());
        Assert.assertEquals((String)"drained[0].from", (long)0L, (long)destination.drainPoints.get((int)0).position);
        Assert.assertEquals((String)"drained[0].to", (long)destination.buffer.capacity(), (long)destination.drainPoints.get((int)0).limit);
        Assert.assertEquals((String)"drained[0].length", (long)destination.buffer.capacity(), (long)destination.drainPoints.get(0).length());
        Assert.assertEquals((String)"destination.buf.pos", (long)(text.length() - destination.buffer.capacity()), (long)destination.buffer.position());
        for (i = 0; i < destination.buffer.capacity(); ++i) {
            Assert.assertEquals((String)("char at " + i), (long)((byte)text.charAt(i)), (long)destination.drained.get(i));
        }
        for (i = destination.buffer.capacity(); i < text.length(); ++i) {
            int bufIx = i - destination.buffer.capacity();
            Assert.assertEquals((String)("char at " + i), (long)((byte)text.charAt(i)), (long)destination.buffer.get(bufIx));
        }
    }

    @Test
    public void testEncodeText_TextFitCharBuff_BytesDontFitByteBuff_MultiplePasses() throws Exception {
        int i;
        StringBuilderEncoder helper = new StringBuilderEncoder(StandardCharsets.UTF_8, 16, 8192);
        StringBuilder text = this.createText(15);
        SpyByteBufferDestination destination = new SpyByteBufferDestination(4, 20);
        helper.encode(text, (ByteBufferDestination)destination);
        Assert.assertEquals((String)"drained", (long)3L, (long)destination.drainPoints.size());
        Assert.assertEquals((String)"drained[0].from", (long)0L, (long)destination.drainPoints.get((int)0).position);
        Assert.assertEquals((String)"drained[0].to", (long)destination.buffer.capacity(), (long)destination.drainPoints.get((int)0).limit);
        Assert.assertEquals((String)"drained[0].length", (long)destination.buffer.capacity(), (long)destination.drainPoints.get(0).length());
        Assert.assertEquals((String)"drained[1].from", (long)0L, (long)destination.drainPoints.get((int)1).position);
        Assert.assertEquals((String)"drained[1].to", (long)destination.buffer.capacity(), (long)destination.drainPoints.get((int)1).limit);
        Assert.assertEquals((String)"drained[1].length", (long)destination.buffer.capacity(), (long)destination.drainPoints.get(1).length());
        Assert.assertEquals((String)"drained[2].from", (long)0L, (long)destination.drainPoints.get((int)2).position);
        Assert.assertEquals((String)"drained[2].to", (long)destination.buffer.capacity(), (long)destination.drainPoints.get((int)2).limit);
        Assert.assertEquals((String)"drained[2].length", (long)destination.buffer.capacity(), (long)destination.drainPoints.get(2).length());
        Assert.assertEquals((String)"destination.buf.pos", (long)(text.length() - 3 * destination.buffer.capacity()), (long)destination.buffer.position());
        for (i = 0; i < 3 * destination.buffer.capacity(); ++i) {
            Assert.assertEquals((String)("char at " + i), (long)((byte)text.charAt(i)), (long)destination.drained.get(i));
        }
        for (i = 3 * destination.buffer.capacity(); i < text.length(); ++i) {
            int bufIx = i - 3 * destination.buffer.capacity();
            Assert.assertEquals((String)("char at " + i), (long)((byte)text.charAt(i)), (long)destination.buffer.get(bufIx));
        }
    }

    @Test
    public void testEncodeText_TextDoesntFitCharBuff_BytesFitByteBuff() throws Exception {
        StringBuilderEncoder helper = new StringBuilderEncoder(StandardCharsets.UTF_8, 4, 8192);
        StringBuilder text = this.createText(15);
        SpyByteBufferDestination destination = new SpyByteBufferDestination(17, 17);
        helper.encode(text, (ByteBufferDestination)destination);
        Assert.assertEquals((String)"drained", (long)0L, (long)destination.drainPoints.size());
        Assert.assertEquals((String)"destination.buf.pos", (long)text.length(), (long)destination.buffer.position());
        for (int i = 0; i < text.length(); ++i) {
            Assert.assertEquals((String)("char at " + i), (long)((byte)text.charAt(i)), (long)destination.buffer.get(i));
        }
    }

    @Test
    public void testEncodeText_JapaneseTextUtf8DoesntFitCharBuff_BytesFitByteBuff() throws Exception {
        StringBuilderEncoder helper = new StringBuilderEncoder(StandardCharsets.UTF_8, 4, 8192);
        StringBuilder text = new StringBuilder("\u65e5\u672c\u8a9e\u30c6\u30b9\u30c8\u6587\u7ae0");
        SpyByteBufferDestination destination = new SpyByteBufferDestination(50, 50);
        helper.encode(text, (ByteBufferDestination)destination);
        Assert.assertEquals((String)"drained", (long)0L, (long)destination.drainPoints.size());
        destination.drain(destination.getByteBuffer());
        byte[] utf8 = text.toString().getBytes(StandardCharsets.UTF_8);
        for (int i = 0; i < utf8.length; ++i) {
            Assert.assertEquals((String)("byte at " + i), (long)utf8[i], (long)destination.drained.get(i));
        }
    }

    @Test
    public void testEncodeText_JapaneseTextShiftJisDoesntFitCharBuff_BytesFitByteBuff() throws Exception {
        Charset SHIFT_JIS = Charset.forName("Shift_JIS");
        StringBuilderEncoder helper = new StringBuilderEncoder(SHIFT_JIS, 4, 8192);
        StringBuilder text = new StringBuilder("\u65e5\u672c\u8a9e\u30c6\u30b9\u30c8\u6587\u7ae0");
        SpyByteBufferDestination destination = new SpyByteBufferDestination(50, 50);
        helper.encode(text, (ByteBufferDestination)destination);
        Assert.assertEquals((String)"drained", (long)0L, (long)destination.drainPoints.size());
        destination.drain(destination.getByteBuffer());
        byte[] bytes = text.toString().getBytes(SHIFT_JIS);
        for (int i = 0; i < bytes.length; ++i) {
            Assert.assertEquals((String)("byte at " + i), (long)bytes[i], (long)destination.drained.get(i));
        }
    }

    @Test
    public void testEncodeText_TextDoesntFitCharBuff_BytesDontFitByteBuff() throws Exception {
        int i;
        StringBuilderEncoder helper = new StringBuilderEncoder(StandardCharsets.UTF_8, 4, 8192);
        StringBuilder text = this.createText(15);
        SpyByteBufferDestination destination = new SpyByteBufferDestination(3, 17);
        helper.encode(text, (ByteBufferDestination)destination);
        Assert.assertEquals((String)"drained", (long)4L, (long)destination.drainPoints.size());
        Assert.assertEquals((String)"destination.buf.pos", (long)3L, (long)destination.buffer.position());
        for (i = 0; i < text.length() - 3; ++i) {
            Assert.assertEquals((String)("char at " + i), (long)((byte)text.charAt(i)), (long)destination.drained.get(i));
        }
        for (i = 0; i < 3; ++i) {
            Assert.assertEquals((String)("char at " + (12 + i)), (long)((byte)text.charAt(12 + i)), (long)destination.buffer.get(i));
        }
    }

    @Test
    public void testEncodeText_JapaneseTextUtf8DoesntFitCharBuff_BytesDontFitByteBuff() throws Exception {
        StringBuilderEncoder helper = new StringBuilderEncoder(StandardCharsets.UTF_8, 4, 8192);
        StringBuilder text = new StringBuilder("\u65e5\u672c\u8a9e\u30c6\u30b9\u30c8\u6587\u7ae0");
        SpyByteBufferDestination destination = new SpyByteBufferDestination(3, 50);
        helper.encode(text, (ByteBufferDestination)destination);
        Assert.assertEquals((String)"drained", (long)7L, (long)destination.drainPoints.size());
        destination.drain(destination.getByteBuffer());
        byte[] utf8 = text.toString().getBytes(StandardCharsets.UTF_8);
        for (int i = 0; i < utf8.length; ++i) {
            Assert.assertEquals((String)("byte at " + i), (long)utf8[i], (long)destination.drained.get(i));
        }
    }

    @Test
    public void testEncodeText_JapaneseTextUtf8DoesntFitCharBuff_DoesntFitTempByteBuff_BytesDontFitDestinationByteBuff() throws Exception {
        StringBuilderEncoder helper = new StringBuilderEncoder(StandardCharsets.UTF_8, 4, 5);
        StringBuilder text = new StringBuilder("\u65e5\u672c\u8a9e\u30c6\u30b9\u30c8\u6587\u7ae0\u65e5\u672c\u8a9e\u30c6\u30b9\u30c8\u6587\u7ae0");
        SpyByteBufferDestination destination = new SpyByteBufferDestination(3, 50);
        helper.encode(text, (ByteBufferDestination)destination);
        Assert.assertEquals((String)"drained", (long)15L, (long)destination.drainPoints.size());
        destination.drain(destination.getByteBuffer());
        byte[] utf8 = text.toString().getBytes(StandardCharsets.UTF_8);
        for (int i = 0; i < utf8.length; ++i) {
            Assert.assertEquals((String)("byte at " + i), (long)utf8[i], (long)destination.drained.get(i));
        }
    }

    @Test
    public void testEncodeText_JapaneseTextShiftJisDoesntFitCharBuff_BytesDontFitByteBuff() throws Exception {
        Charset SHIFT_JIS = Charset.forName("Shift_JIS");
        StringBuilderEncoder helper = new StringBuilderEncoder(SHIFT_JIS, 4, 8192);
        StringBuilder text = new StringBuilder("\u65e5\u672c\u8a9e\u30c6\u30b9\u30c8\u6587\u7ae0");
        SpyByteBufferDestination destination = new SpyByteBufferDestination(3, 50);
        helper.encode(text, (ByteBufferDestination)destination);
        destination.drain(destination.getByteBuffer());
        byte[] bytes = text.toString().getBytes(SHIFT_JIS);
        for (int i = 0; i < bytes.length; ++i) {
            Assert.assertEquals((String)("byte at " + i), (long)bytes[i], (long)destination.drained.get(i));
        }
    }

    @Test
    public void testEncodeText_JapaneseTextShiftJisDoesntFitCharBuff_DoesntFitTempByteBuff_BytesDontFitDestinationByteBuff() throws Exception {
        Charset SHIFT_JIS = Charset.forName("Shift_JIS");
        StringBuilderEncoder helper = new StringBuilderEncoder(SHIFT_JIS, 4, 5);
        StringBuilder text = new StringBuilder("\u65e5\u672c\u8a9e\u30c6\u30b9\u30c8\u6587\u7ae0\u65e5\u672c\u8a9e\u30c6\u30b9\u30c8\u6587\u7ae0");
        SpyByteBufferDestination destination = new SpyByteBufferDestination(3, 50);
        helper.encode(text, (ByteBufferDestination)destination);
        destination.drain(destination.getByteBuffer());
        byte[] bytes = text.toString().getBytes(SHIFT_JIS);
        for (int i = 0; i < bytes.length; ++i) {
            Assert.assertEquals((String)("byte at " + i), (long)bytes[i], (long)destination.drained.get(i));
        }
    }

    @Test
    public void testCopyCopiesAllDataIfSuffientRemainingSpace() throws Exception {
        CharBuffer buff = CharBuffer.wrap(new char[16]);
        StringBuilder text = this.createText(15);
        int length = TextEncoderHelper.copy((StringBuilder)text, (int)0, (CharBuffer)buff);
        Assert.assertEquals((String)"everything fits", (long)text.length(), (long)length);
        for (int i = 0; i < length; ++i) {
            Assert.assertEquals((String)("char at " + i), (long)text.charAt(i), (long)buff.get(i));
        }
        Assert.assertEquals((String)"position moved by length", (long)text.length(), (long)buff.position());
    }

    @Test
    public void testCopyUpToRemainingSpace() throws Exception {
        CharBuffer buff = CharBuffer.wrap(new char[3]);
        StringBuilder text = this.createText(15);
        int length = TextEncoderHelper.copy((StringBuilder)text, (int)0, (CharBuffer)buff);
        Assert.assertEquals((String)"partial copy", (long)buff.capacity(), (long)length);
        for (int i = 0; i < length; ++i) {
            Assert.assertEquals((String)("char at " + i), (long)text.charAt(i), (long)buff.get(i));
        }
        Assert.assertEquals((String)"no space remaining", (long)0L, (long)buff.remaining());
        Assert.assertEquals((String)"position at end", (long)buff.capacity(), (long)buff.position());
    }

    @Test
    public void testCopyDoesNotWriteBeyondStringText() throws Exception {
        int i;
        CharBuffer buff = CharBuffer.wrap(new char[5]);
        Assert.assertEquals((String)"initial buffer position", (long)0L, (long)buff.position());
        StringBuilder text = this.createText(2);
        int length = TextEncoderHelper.copy((StringBuilder)text, (int)0, (CharBuffer)buff);
        Assert.assertEquals((String)"full copy", (long)text.length(), (long)length);
        for (i = 0; i < length; ++i) {
            Assert.assertEquals((String)("char at " + i), (long)text.charAt(i), (long)buff.get(i));
        }
        Assert.assertEquals((String)"resulting buffer position", (long)text.length(), (long)buff.position());
        for (i = length; i < buff.capacity(); ++i) {
            Assert.assertEquals((String)("unset char at " + i), (long)0L, (long)buff.get(i));
        }
    }

    @Test
    public void testCopyStartsAtBufferPosition() throws Exception {
        CharBuffer buff = CharBuffer.wrap(new char[10]);
        int START_POSITION = 5;
        buff.position(5);
        StringBuilder text = this.createText(15);
        int length = TextEncoderHelper.copy((StringBuilder)text, (int)0, (CharBuffer)buff);
        Assert.assertEquals((String)"partial copy", (long)(buff.capacity() - 5), (long)length);
        for (int i = 0; i < length; ++i) {
            Assert.assertEquals((String)("char at " + i), (long)text.charAt(i), (long)buff.get(5 + i));
        }
        Assert.assertEquals((String)"buffer position at end", (long)buff.capacity(), (long)buff.position());
    }

    @Test
    public void testEncode_ALotWithoutErrors() throws Exception {
        StringBuilderEncoder helper = new StringBuilderEncoder(Charset.defaultCharset());
        StringBuilder text = new StringBuilder("2016-04-13 21:07:47,487 DEBUG [org.apache.logging.log4j.perf.jmh.FileAppenderBenchmark.log4j2ParameterizedString-jmh-worker-1] FileAppenderBenchmark  - This is a debug [2383178] message\r\n");
        int DESTINATION_SIZE = 0x100000;
        SpyByteBufferDestination destination = new SpyByteBufferDestination(262144, 0x100000);
        int max = 0x100000 / text.length();
        for (int i = 0; i < max; ++i) {
            helper.encode(text, (ByteBufferDestination)destination);
        }
    }

    private StringBuilder createText(int length) {
        StringBuilder result = new StringBuilder(length);
        for (int i = 0; i < length; ++i) {
            result.append((char)(32 + i));
        }
        return result;
    }
}

