/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.layout;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import org.apache.logging.log4j.ThreadContext;
import org.apache.logging.log4j.core.Logger;
import org.apache.logging.log4j.junit.LoggerContextRule;
import org.junit.After;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;

public class GelfLayoutTest3 {
    @ClassRule
    public static LoggerContextRule context = new LoggerContextRule("GelfLayoutTest3.xml");

    @After
    public void teardown() throws Exception {
        ThreadContext.clearMap();
    }

    @Test
    public void gelfLayout() throws IOException {
        Logger logger = context.getLogger();
        ThreadContext.put((String)"loginId", (String)"rgoers");
        ThreadContext.put((String)"internalId", (String)"12345");
        logger.info("My Test Message");
        String gelf = context.getListAppender("list").getMessages().get(0);
        ObjectMapper mapper = new ObjectMapper();
        JsonNode json = mapper.readTree(gelf);
        Assert.assertEquals((Object)"My Test Message", (Object)json.get("short_message").asText());
        Assert.assertEquals((Object)"myhost", (Object)json.get("host").asText());
        Assert.assertNotNull((Object)json.get("_loginId"));
        Assert.assertEquals((Object)"rgoers", (Object)json.get("_loginId").asText());
        Assert.assertNull((Object)json.get("_internalId"));
        Assert.assertNull((Object)json.get("_requestId"));
        String message = json.get("full_message").asText();
        Assert.assertTrue((boolean)message.contains("loginId=rgoers"));
        Assert.assertTrue((boolean)message.contains("GelfLayoutTest3"));
    }
}

