/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.filter;

import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.filter.NoMarkerFilter;
import org.apache.logging.log4j.core.impl.Log4jLogEvent;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.SimpleMessage;
import org.junit.Assert;
import org.junit.Test;

public class NoMarkerFilterTest {
    @Test
    public void testMarkers() {
        Marker sampleMarker = MarkerManager.getMarker((String)"SampleMarker");
        NoMarkerFilter filter = NoMarkerFilter.newBuilder().build();
        filter.start();
        Assert.assertTrue((boolean)filter.isStarted());
        Assert.assertSame((Object)Filter.Result.DENY, (Object)filter.filter(null, null, sampleMarker, null, (Throwable)null));
        Assert.assertSame((Object)Filter.Result.NEUTRAL, (Object)filter.filter(null, null, null, null, (Throwable)null));
        filter.stop();
        Log4jLogEvent event = Log4jLogEvent.newBuilder().setLevel(Level.DEBUG).setMessage((Message)new SimpleMessage("Hello, world!")).build();
        Assert.assertSame((Object)Filter.Result.NEUTRAL, (Object)filter.filter((LogEvent)event));
        filter.start();
        Assert.assertSame((Object)Filter.Result.NEUTRAL, (Object)filter.filter((LogEvent)event));
        event = Log4jLogEvent.newBuilder().setMarker(sampleMarker).setLevel(Level.DEBUG).setMessage((Message)new SimpleMessage("Hello, world!")).build();
        Assert.assertSame((Object)Filter.Result.DENY, (Object)filter.filter((LogEvent)event));
        filter.stop();
    }
}

