/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.config.properties;

import java.util.Map;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.LifeCycle;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.filter.ThresholdFilter;
import org.apache.logging.log4j.junit.LoggerContextRule;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;

public class PropertiesConfigurationTrailingSpaceOnLevelTest {
    @ClassRule
    public static LoggerContextRule context = new LoggerContextRule("log4j2-properties-trailing-space-on-level.properties");

    @Test
    public void testPropertiesConfiguration() {
        Configuration config = context.getConfiguration();
        Assert.assertNotNull((String)"No configuration created", (Object)config);
        Assert.assertEquals((String)("Incorrect State: " + config.getState()), (Object)config.getState(), (Object)LifeCycle.State.STARTED);
        Map appenders = config.getAppenders();
        Assert.assertNotNull((Object)appenders);
        Assert.assertTrue((String)("Incorrect number of Appenders: " + appenders.size()), (appenders.size() == 1 ? 1 : 0) != 0);
        Map loggers = config.getLoggers();
        Assert.assertNotNull((Object)loggers);
        Assert.assertTrue((String)("Incorrect number of LoggerConfigs: " + loggers.size()), (loggers.size() == 2 ? 1 : 0) != 0);
        Filter filter = config.getFilter();
        Assert.assertNotNull((String)"No Filter", (Object)filter);
        Assert.assertTrue((String)"Not a Threshold Filter", (boolean)(filter instanceof ThresholdFilter));
        Logger logger = LogManager.getLogger(this.getClass());
        Assert.assertEquals((String)("Incorrect level " + logger.getLevel()), (Object)Level.DEBUG, (Object)logger.getLevel());
        logger.debug("Welcome to Log4j!");
    }
}

