/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.async;

import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.categories.AsyncLoggers;
import org.apache.logging.log4j.core.async.DefaultAsyncQueueFullPolicy;
import org.apache.logging.log4j.core.async.EventRoute;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={AsyncLoggers.class})
public class DefaultAsyncQueueFullPolicyTest {
    private static long currentThreadId() {
        return Thread.currentThread().getId();
    }

    private static long otherThreadId() {
        return -1L;
    }

    @Test
    public void testGetRouteEnqueuesIfQueueFullAndCalledFromDifferentThread() throws Exception {
        DefaultAsyncQueueFullPolicy router = new DefaultAsyncQueueFullPolicy();
        Assert.assertEquals((Object)EventRoute.ENQUEUE, (Object)router.getRoute(DefaultAsyncQueueFullPolicyTest.otherThreadId(), Level.ALL));
        Assert.assertEquals((Object)EventRoute.ENQUEUE, (Object)router.getRoute(DefaultAsyncQueueFullPolicyTest.otherThreadId(), Level.OFF));
    }

    @Test
    public void testGetRouteSynchronousIfQueueFullAndCalledFromSameThread() throws Exception {
        DefaultAsyncQueueFullPolicy router = new DefaultAsyncQueueFullPolicy();
        Assert.assertEquals((Object)EventRoute.SYNCHRONOUS, (Object)router.getRoute(DefaultAsyncQueueFullPolicyTest.currentThreadId(), Level.ALL));
        Assert.assertEquals((Object)EventRoute.SYNCHRONOUS, (Object)router.getRoute(DefaultAsyncQueueFullPolicyTest.currentThreadId(), Level.OFF));
    }
}

