/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.appender.rolling;

import java.io.File;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributeView;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.junit.LoggerContextRule;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;

public class RollingAppenderOnStartupTest {
    private static final String SOURCE = "src/test/resources/__files";
    private static final String DIR = "target/onStartup";
    private static final String CONFIG = "log4j-test4.xml";
    private static final String FILENAME = "onStartup.log";
    private Logger logger;
    @Rule
    public LoggerContextRule loggerContextRule = LoggerContextRule.createShutdownTimeoutLoggerContextRule("log4j-test4.xml");

    @Before
    public void setUp() throws Exception {
        this.logger = this.loggerContextRule.getLogger(RollingAppenderOnStartupTest.class.getName());
    }

    @BeforeClass
    public static void beforeClass() throws Exception {
        if (Files.exists(Paths.get(DIR, new String[0]), new LinkOption[0])) {
            try (DirectoryStream<Path> directoryStream = Files.newDirectoryStream(Paths.get(DIR, new String[0]));){
                for (Path path : directoryStream) {
                    Files.delete(path);
                }
                Files.delete(Paths.get(DIR, new String[0]));
            }
        }
        Files.createDirectory(new File(DIR).toPath(), new FileAttribute[0]);
        Path target = Paths.get(DIR, FILENAME);
        Files.copy(Paths.get(SOURCE, FILENAME), target, StandardCopyOption.COPY_ATTRIBUTES);
        FileTime newTime = FileTime.from(Instant.now().minus(1L, ChronoUnit.DAYS));
        Files.getFileAttributeView(target, BasicFileAttributeView.class, new LinkOption[0]).setTimes(newTime, newTime, newTime);
    }

    @AfterClass
    public static void afterClass() throws Exception {
        try (DirectoryStream<Path> directoryStream = Files.newDirectoryStream(Paths.get(DIR, new String[0]));){
            boolean rolled = false;
            for (Path path : directoryStream) {
                if (!path.toFile().getName().endsWith(FILENAME)) {
                    rolled = true;
                }
                try (Stream<String> stream = Files.lines(path);){
                    List lines = stream.collect(Collectors.toList());
                    Assert.assertTrue((String)("No header present for " + path.toFile().getName()), (boolean)((String)lines.get(0)).startsWith("<!DOCTYPE HTML"));
                }
                Files.delete(path);
            }
            Assert.assertTrue((String)"File did not roll", (boolean)rolled);
        }
        Files.delete(Paths.get(DIR, new String[0]));
    }

    @Test
    public void testAppender() throws Exception {
        for (int i = 0; i < 100; ++i) {
            this.logger.debug("This is test message number " + i);
        }
    }
}

