/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.appender;

import java.io.File;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.categories.Layouts;
import org.apache.logging.log4j.core.CoreLoggerContexts;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={Layouts.Xml.class})
public class XmlFileAppenderTest {
    @BeforeClass
    public static void beforeClass() {
        System.setProperty("log4j.configurationFile", "XmlFileAppenderTest.xml");
    }

    @Test
    public void testFlushAtEndOfBatch() throws Exception {
        File file = new File("target", "XmlFileAppenderTest.log");
        file.delete();
        Logger log = LogManager.getLogger((String)"com.foo.Bar");
        String logMsg = "Message flushed with immediate flush=false";
        log.info("Message flushed with immediate flush=false");
        CoreLoggerContexts.stopLoggerContext(false, file);
        List<String> lines = Files.readAllLines(file.toPath(), Charset.forName("UTF8"));
        file.delete();
        String[] expect = new String[]{"", "<Event ", "<Instant epochSecond=", "Message flushed with immediate flush=false", "</Event>"};
        for (int i = 0; i < expect.length; ++i) {
            Assert.assertTrue((String)("Expected line " + i + " to contain " + expect[i] + " but got: " + lines.get(i)), (boolean)lines.get(i).contains(expect[i]));
        }
        String location = "testFlushAtEndOfBatch";
        Assert.assertTrue((String)"no location", (!lines.get(0).contains("testFlushAtEndOfBatch") ? 1 : 0) != 0);
    }
}

