/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.time;

import org.apache.logging.log4j.core.time.Instant;
import org.apache.logging.log4j.core.time.MutableInstant;
import org.apache.logging.log4j.core.time.internal.FixedPreciseClock;
import org.apache.logging.log4j.core.util.Clock;
import org.junit.Assert;
import org.junit.Test;

public class MutableInstantTest {
    @Test
    public void testGetEpochSecond() {
        MutableInstant instant = new MutableInstant();
        Assert.assertEquals((String)"initial", (long)0L, (long)instant.getEpochSecond());
        instant.initFromEpochSecond(123L, 456);
        Assert.assertEquals((String)"returns directly set value", (long)123L, (long)instant.getEpochSecond());
        instant.initFromEpochMilli(123456L, 789012);
        Assert.assertEquals((String)"returns converted value when initialized from milllis", (long)123L, (long)instant.getEpochSecond());
        MutableInstant other = new MutableInstant();
        other.initFromEpochSecond(788L, 456);
        instant.initFrom((Instant)other);
        Assert.assertEquals((String)"returns ref value when initialized from instant", (long)788L, (long)instant.getEpochSecond());
    }

    @Test
    public void testGetNanoOfSecond() {
        MutableInstant instant = new MutableInstant();
        Assert.assertEquals((String)"initial", (long)0L, (long)instant.getNanoOfSecond());
        instant.initFromEpochSecond(123L, 456);
        Assert.assertEquals((String)"returns directly set value", (long)456L, (long)instant.getNanoOfSecond());
        instant.initFromEpochMilli(123456L, 789012);
        Assert.assertEquals((String)"returns converted value when initialized from milllis", (long)456789012L, (long)instant.getNanoOfSecond());
        MutableInstant other = new MutableInstant();
        other.initFromEpochSecond(788L, 456);
        instant.initFrom((Instant)other);
        Assert.assertEquals((String)"returns ref value when initialized from instant", (long)456L, (long)instant.getNanoOfSecond());
    }

    @Test
    public void testGetEpochMillisecond() {
        MutableInstant instant = new MutableInstant();
        Assert.assertEquals((String)"initial", (long)0L, (long)instant.getEpochMillisecond());
        instant.initFromEpochMilli(123L, 456);
        Assert.assertEquals((String)"returns directly set value", (long)123L, (long)instant.getEpochMillisecond());
        instant.initFromEpochSecond(123L, 456789012);
        Assert.assertEquals((String)"returns converted value when initialized from seconds", (long)123456L, (long)instant.getEpochMillisecond());
        MutableInstant other = new MutableInstant();
        other.initFromEpochMilli(788L, 456);
        instant.initFrom((Instant)other);
        Assert.assertEquals((String)"returns ref value when initialized from instant", (long)788L, (long)instant.getEpochMillisecond());
    }

    @Test
    public void getGetNanoOfMillisecond() {
        MutableInstant instant = new MutableInstant();
        Assert.assertEquals((String)"initial", (long)0L, (long)instant.getNanoOfMillisecond());
        instant.initFromEpochMilli(123L, 456);
        Assert.assertEquals((String)"returns directly set value", (long)456L, (long)instant.getNanoOfMillisecond());
        instant.initFromEpochSecond(123L, 456789012);
        Assert.assertEquals((String)"returns converted value when initialized from milllis", (long)789012L, (long)instant.getNanoOfMillisecond());
        MutableInstant other = new MutableInstant();
        other.initFromEpochMilli(788L, 456);
        instant.initFrom((Instant)other);
        Assert.assertEquals((String)"returns ref value when initialized from instant", (long)456L, (long)instant.getNanoOfMillisecond());
    }

    @Test(expected=NullPointerException.class)
    public void testInitFromInstantRejectsNull() {
        new MutableInstant().initFrom((Instant)null);
    }

    @Test
    public void testInitFromInstantCopiesValues() {
        MutableInstant other = new MutableInstant();
        other.initFromEpochSecond(788L, 456);
        Assert.assertEquals((String)"epochSec", (long)788L, (long)other.getEpochSecond());
        Assert.assertEquals((String)"NanosOfSec", (long)456L, (long)other.getNanoOfSecond());
        MutableInstant instant = new MutableInstant();
        instant.initFrom((Instant)other);
        Assert.assertEquals((String)"epochSec", (long)788L, (long)instant.getEpochSecond());
        Assert.assertEquals((String)"NanoOfSec", (long)456L, (long)instant.getNanoOfSecond());
    }

    @Test
    public void testInitFromEpochMillis() {
        MutableInstant instant = new MutableInstant();
        instant.initFromEpochMilli(123456L, 789012);
        Assert.assertEquals((String)"epochSec", (long)123L, (long)instant.getEpochSecond());
        Assert.assertEquals((String)"NanoOfSec", (long)456789012L, (long)instant.getNanoOfSecond());
        Assert.assertEquals((String)"epochMilli", (long)123456L, (long)instant.getEpochMillisecond());
        Assert.assertEquals((String)"NanoOfMilli", (long)789012L, (long)instant.getNanoOfMillisecond());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testInitFromEpochMillisRejectsNegativeNanoOfMilli() {
        MutableInstant instant = new MutableInstant();
        instant.initFromEpochMilli(123456L, -1);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testInitFromEpochMillisRejectsTooLargeNanoOfMilli() {
        MutableInstant instant = new MutableInstant();
        instant.initFromEpochMilli(123456L, 1000000);
    }

    @Test
    public void testInitFromEpochMillisAcceptsTooMaxNanoOfMilli() {
        MutableInstant instant = new MutableInstant();
        instant.initFromEpochMilli(123456L, 999999);
        Assert.assertEquals((String)"NanoOfMilli", (long)999999L, (long)instant.getNanoOfMillisecond());
    }

    @Test
    public void testInitFromEpochSecond() {
        MutableInstant instant = new MutableInstant();
        instant.initFromEpochSecond(123L, 456789012);
        Assert.assertEquals((String)"epochSec", (long)123L, (long)instant.getEpochSecond());
        Assert.assertEquals((String)"NanoOfSec", (long)456789012L, (long)instant.getNanoOfSecond());
        Assert.assertEquals((String)"epochMilli", (long)123456L, (long)instant.getEpochMillisecond());
        Assert.assertEquals((String)"NanoOfMilli", (long)789012L, (long)instant.getNanoOfMillisecond());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testInitFromEpochSecondRejectsNegativeNanoOfMilli() {
        MutableInstant instant = new MutableInstant();
        instant.initFromEpochSecond(123456L, -1);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testInitFromEpochSecondRejectsTooLargeNanoOfMilli() {
        MutableInstant instant = new MutableInstant();
        instant.initFromEpochSecond(123456L, 1000000000);
    }

    @Test
    public void testInitFromEpochSecondAcceptsTooMaxNanoOfMilli() {
        MutableInstant instant = new MutableInstant();
        instant.initFromEpochSecond(123456L, 999999999);
        Assert.assertEquals((String)"NanoOfSec", (long)999999999L, (long)instant.getNanoOfSecond());
    }

    @Test
    public void testInstantToMillisAndNanos() {
        long[] values = new long[2];
        MutableInstant.instantToMillisAndNanos((long)123456L, (int)999999999, (long[])values);
        Assert.assertEquals((long)123456999L, (long)values[0]);
        Assert.assertEquals((long)999999L, (long)values[1]);
    }

    @Test
    public void testInitFromClock() {
        MutableInstant instant = new MutableInstant();
        FixedPreciseClock clock = new FixedPreciseClock(123456L, 789012);
        instant.initFrom((Clock)clock);
        Assert.assertEquals((long)123456L, (long)instant.getEpochMillisecond());
        Assert.assertEquals((long)789012L, (long)instant.getNanoOfMillisecond());
        Assert.assertEquals((long)123L, (long)instant.getEpochSecond());
        Assert.assertEquals((long)456789012L, (long)instant.getNanoOfSecond());
    }

    @Test
    public void testEquals() {
        MutableInstant instant = new MutableInstant();
        instant.initFromEpochSecond(123L, 456789012);
        MutableInstant instant2 = new MutableInstant();
        instant2.initFromEpochMilli(123456L, 789012);
        Assert.assertEquals((Object)instant, (Object)instant2);
    }

    @Test
    public void testHashCode() {
        MutableInstant instant = new MutableInstant();
        instant.initFromEpochSecond(123L, 456789012);
        MutableInstant instant2 = new MutableInstant();
        instant2.initFromEpochMilli(123456L, 789012);
        Assert.assertEquals((long)instant.hashCode(), (long)instant2.hashCode());
        instant2.initFromEpochMilli(123456L, 789013);
        Assert.assertNotEquals((long)instant.hashCode(), (long)instant2.hashCode());
    }

    @Test
    public void testToString() {
        MutableInstant instant = new MutableInstant();
        instant.initFromEpochSecond(123L, 456789012);
        Assert.assertEquals((Object)"MutableInstant[epochSecond=123, nano=456789012]", (Object)instant.toString());
        instant.initFromEpochMilli(123456L, 789012);
        Assert.assertEquals((Object)"MutableInstant[epochSecond=123, nano=456789012]", (Object)instant.toString());
    }
}

