/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.filter;

import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.Logger;
import org.apache.logging.log4j.core.filter.AbstractFilter;
import org.apache.logging.log4j.message.Message;
import org.junit.Assert;
import org.junit.Test;

public class AbstractFilterTest {
    @Test
    public void testUnrolledBackwardsCompatible() {
        ConcreteFilter filter = new ConcreteFilter();
        Filter.Result expected = Filter.Result.DENY;
        this.verifyMethodsWithUnrolledVarargs(filter, Filter.Result.DENY);
        filter.testResult = Filter.Result.ACCEPT;
        this.verifyMethodsWithUnrolledVarargs(filter, Filter.Result.ACCEPT);
    }

    private void verifyMethodsWithUnrolledVarargs(ConcreteFilter filter, Filter.Result expected) {
        Logger logger = null;
        Level level = null;
        Marker marker = null;
        Assert.assertEquals((Object)expected, (Object)filter.filter(logger, level, marker, "", 1));
        Assert.assertEquals((Object)expected, (Object)filter.filter(logger, level, marker, "", 1, 2));
        Assert.assertEquals((Object)expected, (Object)filter.filter(logger, level, marker, "", 1, 2, 3));
        Assert.assertEquals((Object)expected, (Object)filter.filter(logger, level, marker, "", 1, 2, 3, 4));
        Assert.assertEquals((Object)expected, (Object)filter.filter(logger, level, marker, "", 1, 2, 3, 4, 5));
        Assert.assertEquals((Object)expected, (Object)filter.filter(logger, level, marker, "", 1, 2, 3, 4, 5, 6));
        Assert.assertEquals((Object)expected, (Object)filter.filter(logger, level, marker, "", 1, 2, 3, 4, 5, 6, 7));
        Assert.assertEquals((Object)expected, (Object)filter.filter(logger, level, marker, "", 1, 2, 3, 4, 5, 6, 7, 8));
        Assert.assertEquals((Object)expected, (Object)filter.filter(logger, level, marker, "", 1, 2, 3, 4, 5, 6, 7, 8, 9));
        Assert.assertEquals((Object)expected, (Object)filter.filter(logger, level, marker, "", 1, 2, 3, 4, 5, 6, 7, 8, 9, 10));
    }

    static class ConcreteFilter
    extends AbstractFilter {
        Filter.Result testResult = Filter.Result.DENY;

        ConcreteFilter() {
        }

        public Filter.Result filter(LogEvent event) {
            return this.testResult;
        }

        public Filter.Result filter(Logger logger, Level level, Marker marker, Message msg, Throwable t) {
            return this.testResult;
        }

        public Filter.Result filter(Logger logger, Level level, Marker marker, Object msg, Throwable t) {
            return this.testResult;
        }

        public Filter.Result filter(Logger logger, Level level, Marker marker, String msg, Object ... params) {
            return this.testResult;
        }
    }
}

