/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.config;

import java.io.File;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.junit.LoggerContextRule;
import org.apache.logging.log4j.message.ThreadDumpMessage;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;

public class ReconfigurationDeadlockTest {
    @Rule
    public LoggerContextRule init = new LoggerContextRule("reconfiguration-deadlock.xml");
    private static final int THREAD_COUNT = 5;
    private static final boolean[] finished = new boolean[5];
    private static LoggerThread[] threads = new LoggerThread[5];

    @Test
    public void testReconfig() throws InterruptedException {
        int i;
        int i2;
        Updater updater = new Updater();
        for (i2 = 0; i2 < 5; ++i2) {
            ReconfigurationDeadlockTest.threads[i2] = new LoggerThread(i2);
            threads[i2].setDaemon(true);
        }
        for (i2 = 0; i2 < 5; ++i2) {
            threads[i2].start();
        }
        updater.setDaemon(true);
        updater.start();
        Thread.sleep(100L);
        boolean stillWaiting = true;
        for (i = 0; i < 200; ++i) {
            int index;
            for (index = 0; index < 5 && finished[index]; ++index) {
            }
            if (index == 5) {
                stillWaiting = false;
                break;
            }
            Thread.sleep(100L);
        }
        updater.shutdown = true;
        if (stillWaiting) {
            ThreadDumpMessage message = new ThreadDumpMessage("Waiting");
            System.err.print(message.getFormattedMessage());
        }
        for (i = 0; i < 5; ++i) {
            if (!threads[i].isAlive()) continue;
            threads[i].interrupt();
        }
        Assert.assertFalse((String)"loggerThread didn't finish", (boolean)stillWaiting);
    }

    private class Updater
    extends Thread {
        public volatile boolean shutdown = false;

        private Updater() {
        }

        @Override
        public void run() {
            while (!this.shutdown) {
                File file;
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                if (!(file = new File("target/test-classes/reconfiguration-deadlock.xml")).exists()) continue;
                file.setLastModified(System.currentTimeMillis());
            }
        }
    }

    private class LoggerThread
    extends Thread {
        private final Logger logger = LogManager.getRootLogger();
        private final int index;

        public LoggerThread(int i) {
            this.index = i;
        }

        @Override
        public void run() {
            int i = 0;
            try {
                for (i = 0; i < 30; ++i) {
                    this.logger.error("Thread: " + this.index + ", Test: " + i++);
                }
            }
            catch (Exception ie) {
                return;
            }
            finished[this.index] = true;
        }
    }
}

