/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.appender;

import java.lang.reflect.Field;
import java.util.Map;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.Logger;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.appender.AbstractManager;
import org.apache.logging.log4j.core.appender.RollingFileAppender;
import org.apache.logging.log4j.core.appender.rolling.DirectWriteRolloverStrategy;
import org.apache.logging.log4j.core.appender.rolling.RolloverStrategy;
import org.apache.logging.log4j.core.appender.rolling.SizeBasedTriggeringPolicy;
import org.apache.logging.log4j.core.appender.rolling.TriggeringPolicy;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.Configurator;
import org.apache.logging.log4j.core.config.builder.api.ConfigurationBuilder;
import org.apache.logging.log4j.core.config.builder.api.ConfigurationBuilderFactory;
import org.apache.logging.log4j.core.layout.PatternLayout;
import org.junit.Test;

public class ReconfigureAppenderTest {
    private RollingFileAppender appender;

    @Test
    public void addAndRemoveAppenderTest() {
        this.createAndAddAppender();
        Logger logger = (Logger)LogManager.getLogger(this.getClass());
        logger.info("test message 1");
        this.removeAppender();
        this.createAndAddAppender();
        logger.info("test message 2");
        this.removeAppender();
        this.removeManagerUsingReflection();
        this.createAndAddAppender();
        logger.info("test message 3");
    }

    private void removeManagerUsingReflection() {
        try {
            Field field = AbstractManager.class.getDeclaredField("MAP");
            field.setAccessible(true);
            Map map = (Map)field.get(null);
            map.remove(this.appender.getFilePattern());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void removeAppender() {
        Logger logger = (Logger)LogManager.getLogger(this.getClass());
        this.appender.stop();
        logger.removeAppender((Appender)this.appender);
    }

    private void createAndAddAppender() {
        ConfigurationBuilder config_builder = ConfigurationBuilderFactory.newConfigurationBuilder();
        config_builder.add(config_builder.newRootLogger(Level.INFO));
        LoggerContext logger_context = Configurator.initialize((Configuration)((Configuration)config_builder.build()));
        Logger logger = (Logger)LogManager.getLogger(this.getClass());
        PatternLayout.Builder pattern_builder = PatternLayout.newBuilder().withPattern("[%d{dd-MM-yy HH:mm:ss}] %p %m %throwable %n");
        PatternLayout pattern_layout = (PatternLayout)pattern_builder.build();
        this.appender = ((RollingFileAppender.Builder)((RollingFileAppender.Builder)((RollingFileAppender.Builder)RollingFileAppender.newBuilder().withLayout((Layout)pattern_layout)).withName("rollingfileappender")).withFilePattern("target/filepattern.%i.log").withPolicy((TriggeringPolicy)SizeBasedTriggeringPolicy.createPolicy((String)"5 MB")).withAppend(true).withStrategy((RolloverStrategy)DirectWriteRolloverStrategy.newBuilder().withConfig(logger_context.getConfiguration()).withMaxFiles("5").build()).setConfiguration(logger_context.getConfiguration())).build();
        this.appender.start();
        logger.addAppender((Appender)this.appender);
    }
}

