/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.appender;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.CoreLoggerContexts;
import org.apache.logging.log4j.core.util.Integers;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class MemoryMappedFileAppenderLocationTest {
    final String LOGFILE = "target/MemoryMappedFileAppenderLocationTest.log";

    @Before
    public void before() {
        System.setProperty("log4j.configurationFile", "MemoryMappedFileAppenderLocationTest.xml");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMemMapLocation() throws Exception {
        String line3;
        String line2;
        String line1;
        File f = new File("target/MemoryMappedFileAppenderLocationTest.log");
        if (f.exists()) {
            Assert.assertTrue((String)"deleted ok", (boolean)f.delete());
        }
        Assert.assertTrue((!f.exists() ? 1 : 0) != 0);
        int expectedFileLength = Integers.ceilingNextPowerOfTwo((int)32000);
        Assert.assertEquals((long)32768L, (long)expectedFileLength);
        Logger log = LogManager.getLogger();
        try {
            log.warn("Test log1");
            Assert.assertTrue((boolean)f.exists());
            Assert.assertEquals((String)"initial length", (long)expectedFileLength, (long)f.length());
            log.warn("Test log2");
            Assert.assertEquals((String)"not grown", (long)expectedFileLength, (long)f.length());
        }
        finally {
            CoreLoggerContexts.stopLoggerContext(false);
        }
        int LINESEP = System.lineSeparator().length();
        Assert.assertEquals((String)"Shrunk to actual used size", (long)(474 + 2 * LINESEP), (long)f.length());
        try (BufferedReader reader = new BufferedReader(new FileReader("target/MemoryMappedFileAppenderLocationTest.log"));){
            line1 = reader.readLine();
            line2 = reader.readLine();
            line3 = reader.readLine();
        }
        Assert.assertNotNull((Object)line1);
        Assert.assertThat((Object)line1, (Matcher)CoreMatchers.containsString((String)"Test log1"));
        String location1 = "org.apache.logging.log4j.core.appender.MemoryMappedFileAppenderLocationTest.testMemMapLocation(MemoryMappedFileAppenderLocationTest.java:65)";
        Assert.assertThat((Object)line1, (Matcher)CoreMatchers.containsString((String)"org.apache.logging.log4j.core.appender.MemoryMappedFileAppenderLocationTest.testMemMapLocation(MemoryMappedFileAppenderLocationTest.java:65)"));
        Assert.assertNotNull((Object)line2);
        Assert.assertThat((Object)line2, (Matcher)CoreMatchers.containsString((String)"Test log2"));
        String location2 = "org.apache.logging.log4j.core.appender.MemoryMappedFileAppenderLocationTest.testMemMapLocation(MemoryMappedFileAppenderLocationTest.java:69)";
        Assert.assertThat((Object)line2, (Matcher)CoreMatchers.containsString((String)"org.apache.logging.log4j.core.appender.MemoryMappedFileAppenderLocationTest.testMemMapLocation(MemoryMappedFileAppenderLocationTest.java:69)"));
        Assert.assertNull((String)"only two lines were logged", (Object)line3);
    }
}

