/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.spring.cloud.config.client;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.spring.cloud.config.client.WatchEventManager;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.cloud.bus.ConditionalOnBusEnabled;
import org.springframework.cloud.bus.SpringCloudBusClient;
import org.springframework.cloud.bus.event.RemoteApplicationEvent;
import org.springframework.cloud.stream.annotation.EnableBinding;
import org.springframework.cloud.stream.annotation.StreamListener;
import org.springframework.context.event.EventListener;
import org.springframework.stereotype.Component;

@Component
@ConditionalOnBusEnabled
@EnableBinding(value={SpringCloudBusClient.class})
@ConditionalOnProperty(value={"spring.cloud.config.watch.enabled"})
public class Log4j2EventListener {
    private static Logger LOGGER = LogManager.getLogger(Log4j2EventListener.class);

    @EventListener(classes={RemoteApplicationEvent.class})
    public void acceptLocal(RemoteApplicationEvent event) {
        LOGGER.debug("Refresh application event triggered");
        WatchEventManager.publishEvent();
    }

    @StreamListener(value="springCloudBusInput")
    public void acceptRemote(RemoteApplicationEvent event) {
        LOGGER.debug("Refresh application event triggered");
        WatchEventManager.publishEvent();
    }
}

