/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.util;

import org.apache.logging.log4j.core.util.CyclicBuffer;
import org.junit.Assert;
import org.junit.Test;

public class CyclicBufferTest {
    @Test
    public void testSize0() {
        CyclicBuffer buffer = new CyclicBuffer(Integer.class, 0);
        Assert.assertTrue((boolean)buffer.isEmpty());
        buffer.add((Object)1);
        Assert.assertTrue((boolean)buffer.isEmpty());
        Integer[] items = (Integer[])buffer.removeAll();
        Assert.assertTrue((String)"Incorrect number of items", (items.length == 0 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)buffer.isEmpty());
        buffer.add((Object)1);
        buffer.add((Object)2);
        buffer.add((Object)3);
        buffer.add((Object)4);
        items = (Integer[])buffer.removeAll();
        Assert.assertTrue((String)"Incorrect number of items", (items.length == 0 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)buffer.isEmpty());
    }

    @Test
    public void testSize1() {
        CyclicBuffer buffer = new CyclicBuffer(Integer.class, 1);
        Assert.assertTrue((boolean)buffer.isEmpty());
        buffer.add((Object)1);
        Assert.assertFalse((boolean)buffer.isEmpty());
        Object[] items = (Integer[])buffer.removeAll();
        Assert.assertTrue((String)"Incorrect number of items", (items.length == 1 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)buffer.isEmpty());
        buffer.add((Object)1);
        buffer.add((Object)2);
        buffer.add((Object)3);
        buffer.add((Object)4);
        items = (Integer[])buffer.removeAll();
        Assert.assertTrue((String)"Incorrect number of items", (items.length == 1 ? 1 : 0) != 0);
        Assert.assertArrayEquals((Object[])new Integer[]{4}, (Object[])items);
        Assert.assertTrue((boolean)buffer.isEmpty());
    }

    @Test
    public void testSize3() {
        CyclicBuffer buffer = new CyclicBuffer(Integer.class, 3);
        Assert.assertTrue((boolean)buffer.isEmpty());
        buffer.add((Object)1);
        Assert.assertFalse((boolean)buffer.isEmpty());
        Object[] items = (Integer[])buffer.removeAll();
        Assert.assertTrue((String)"Incorrect number of items", (items.length == 1 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)buffer.isEmpty());
        buffer.add((Object)1);
        buffer.add((Object)2);
        buffer.add((Object)3);
        buffer.add((Object)4);
        items = (Integer[])buffer.removeAll();
        Assert.assertTrue((String)"Incorrect number of items", (items.length == 3 ? 1 : 0) != 0);
        Assert.assertArrayEquals((Object[])new Integer[]{2, 3, 4}, (Object[])items);
        Assert.assertTrue((boolean)buffer.isEmpty());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testSizeNegative() {
        CyclicBuffer buffer = new CyclicBuffer(Integer.class, -1);
    }
}

