/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.pattern;

import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.ThreadContext;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.impl.Log4jLogEvent;
import org.apache.logging.log4j.core.pattern.RootThrowablePatternConverter;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.SimpleMessage;
import org.junit.Assert;
import org.junit.Test;

public class RootThrowablePatternConverterTest {
    @Test
    public void testSuffix() {
        String suffix = "suffix(test suffix)";
        String[] options = new String[]{"suffix(test suffix)"};
        RootThrowablePatternConverter converter = RootThrowablePatternConverter.newInstance(null, (String[])options);
        NullPointerException cause = new NullPointerException("null pointer");
        IllegalArgumentException parent = new IllegalArgumentException("IllegalArgument", cause);
        Log4jLogEvent event = Log4jLogEvent.newBuilder().setLoggerName("testLogger").setLoggerFqcn(this.getClass().getName()).setLevel(Level.DEBUG).setMessage((Message)new SimpleMessage("test exception")).setThrown((Throwable)parent).build();
        StringBuilder sb = new StringBuilder();
        converter.format((LogEvent)event, sb);
        String result = sb.toString();
        Assert.assertTrue((String)"No suffix", (boolean)result.contains("test suffix"));
    }

    @Test
    public void testSuffixFromNormalPattern() {
        String suffix = "suffix(%mdc{key})";
        ThreadContext.put((String)"key", (String)"test suffix ");
        String[] options = new String[]{"suffix(%mdc{key})"};
        RootThrowablePatternConverter converter = RootThrowablePatternConverter.newInstance(null, (String[])options);
        NullPointerException cause = new NullPointerException("null pointer");
        IllegalArgumentException parent = new IllegalArgumentException("IllegalArgument", cause);
        Log4jLogEvent event = Log4jLogEvent.newBuilder().setLoggerName("testLogger").setLoggerFqcn(this.getClass().getName()).setLevel(Level.DEBUG).setMessage((Message)new SimpleMessage("test exception")).setThrown((Throwable)parent).build();
        StringBuilder sb = new StringBuilder();
        converter.format((LogEvent)event, sb);
        String result = sb.toString();
        Assert.assertTrue((String)"No suffix", (boolean)result.contains("test suffix"));
    }

    @Test
    public void testSuffixWillIgnoreThrowablePattern() {
        String suffix = "suffix(%xEx{suffix(inner suffix)})";
        String[] options = new String[]{"suffix(%xEx{suffix(inner suffix)})"};
        RootThrowablePatternConverter converter = RootThrowablePatternConverter.newInstance(null, (String[])options);
        NullPointerException cause = new NullPointerException("null pointer");
        IllegalArgumentException parent = new IllegalArgumentException("IllegalArgument", cause);
        Log4jLogEvent event = Log4jLogEvent.newBuilder().setLoggerName("testLogger").setLoggerFqcn(this.getClass().getName()).setLevel(Level.DEBUG).setMessage((Message)new SimpleMessage("test exception")).setThrown((Throwable)parent).build();
        StringBuilder sb = new StringBuilder();
        converter.format((LogEvent)event, sb);
        String result = sb.toString();
        Assert.assertFalse((String)"Has unexpected suffix", (boolean)result.contains("inner suffix"));
    }

    @Test
    public void testFull1() {
        RootThrowablePatternConverter converter = RootThrowablePatternConverter.newInstance(null, null);
        NullPointerException cause = new NullPointerException("null pointer");
        IllegalArgumentException parent = new IllegalArgumentException("IllegalArgument", cause);
        Log4jLogEvent event = Log4jLogEvent.newBuilder().setLoggerName("testLogger").setLoggerFqcn(this.getClass().getName()).setLevel(Level.DEBUG).setMessage((Message)new SimpleMessage("test exception")).setThrown((Throwable)parent).build();
        StringBuilder sb = new StringBuilder();
        converter.format((LogEvent)event, sb);
        String result = sb.toString();
        Assert.assertTrue((String)"Missing Exception", (boolean)result.contains("Wrapped by: java.lang.IllegalArgumentException: IllegalArgument"));
        Assert.assertTrue((String)"Incorrect start of msg", (boolean)result.startsWith("java.lang.NullPointerException: null pointer"));
    }

    @Test
    public void testFull2() {
        RootThrowablePatternConverter converter = RootThrowablePatternConverter.newInstance(null, null);
        try {
            try {
                throw new NullPointerException("null pointer");
            }
            catch (NullPointerException e) {
                throw new IllegalArgumentException("IllegalArgument", e);
            }
        }
        catch (IllegalArgumentException e) {
            IllegalArgumentException parent = e;
            Log4jLogEvent event = Log4jLogEvent.newBuilder().setLoggerName("testLogger").setLoggerFqcn(this.getClass().getName()).setLevel(Level.DEBUG).setMessage((Message)new SimpleMessage("test exception")).setThrown((Throwable)parent).build();
            StringBuilder sb = new StringBuilder();
            converter.format((LogEvent)event, sb);
            String result = sb.toString();
            Assert.assertTrue((String)"Missing Exception", (boolean)result.contains("Wrapped by: java.lang.IllegalArgumentException: IllegalArgument"));
            Assert.assertTrue((String)"Incorrect start of msg", (boolean)result.startsWith("java.lang.NullPointerException: null pointer"));
            return;
        }
    }
}

