/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.pattern;

import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.impl.Log4jLogEvent;
import org.apache.logging.log4j.core.pattern.EncodingPatternConverter;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.SimpleMessage;
import org.junit.Assert;
import org.junit.Test;

public class EncodingPatternConverterTest {
    @Test
    public void testReplacement() {
        Log4jLogEvent event = Log4jLogEvent.newBuilder().setLoggerName(EncodingPatternConverterTest.class.getName()).setLevel(Level.DEBUG).setMessage((Message)new SimpleMessage("Test \r\n<div class=\"test\">this</div> & <div class='test'>that</div>")).build();
        StringBuilder sb = new StringBuilder();
        LoggerContext ctx = LoggerContext.getContext();
        String[] options = new String[]{"%msg"};
        EncodingPatternConverter converter = EncodingPatternConverter.newInstance((Configuration)ctx.getConfiguration(), (String[])options);
        Assert.assertNotNull((String)"Error creating converter", (Object)converter);
        converter.format((LogEvent)event, sb);
        Assert.assertEquals((Object)"Test \\r\\n&lt;div class=&quot;test&quot;&gt;this&lt;&#x2F;div&gt; &amp; &lt;div class=&apos;test&apos;&gt;that&lt;&#x2F;div&gt;", (Object)sb.toString());
    }

    @Test
    public void testJsonEscaping() throws Exception {
        Log4jLogEvent event = Log4jLogEvent.newBuilder().setLoggerName(this.getClass().getName()).setLevel(Level.DEBUG).setMessage((Message)new SimpleMessage("This string contains \"quotes\" and \\ backslash and \u001f control and\nnewline")).build();
        String expected = "This string contains \\\"quotes\\\" and \\\\ backslash and \\u001F control and\\nnewline";
        StringBuilder sb = new StringBuilder();
        LoggerContext ctx = LoggerContext.getContext();
        String[] options = new String[]{"%msg", "JSON"};
        EncodingPatternConverter converter = EncodingPatternConverter.newInstance((Configuration)ctx.getConfiguration(), (String[])options);
        Assert.assertNotNull((String)"Error creating converter", (Object)converter);
        converter.format((LogEvent)event, sb);
        Assert.assertEquals((Object)"This string contains \\\"quotes\\\" and \\\\ backslash and \\u001F control and\\nnewline", (Object)sb.toString());
    }

    @Test
    public void testCrlfEscaping() {
        Log4jLogEvent event = Log4jLogEvent.newBuilder().setLoggerName(EncodingPatternConverterTest.class.getName()).setLevel(Level.DEBUG).setMessage((Message)new SimpleMessage("Test \r\n<div class=\"test\">this\r</div> & \n<div class='test'>that</div>")).build();
        StringBuilder sb = new StringBuilder();
        LoggerContext ctx = LoggerContext.getContext();
        String[] options = new String[]{"%msg", "CRLF"};
        EncodingPatternConverter converter = EncodingPatternConverter.newInstance((Configuration)ctx.getConfiguration(), (String[])options);
        Assert.assertNotNull((String)"Error creating converter", (Object)converter);
        converter.format((LogEvent)event, sb);
        Assert.assertEquals((Object)"Test \\r\\n<div class=\"test\">this\\r</div> & \\n<div class='test'>that</div>", (Object)sb.toString());
    }

    @Test
    public void testXmlEscaping() {
        Log4jLogEvent event = Log4jLogEvent.newBuilder().setLoggerName(EncodingPatternConverterTest.class.getName()).setLevel(Level.DEBUG).setMessage((Message)new SimpleMessage("Test \r\n<div class=\"test\">this</div> & <div class='test'>that</div>")).build();
        StringBuilder sb = new StringBuilder();
        LoggerContext ctx = LoggerContext.getContext();
        String[] options = new String[]{"%msg", "XML"};
        EncodingPatternConverter converter = EncodingPatternConverter.newInstance((Configuration)ctx.getConfiguration(), (String[])options);
        Assert.assertNotNull((String)"Error creating converter", (Object)converter);
        converter.format((LogEvent)event, sb);
        Assert.assertEquals((Object)"Test \r\n&lt;div class=&quot;test&quot;&gt;this&lt;/div&gt; &amp; &lt;div class=&apos;test&apos;&gt;that&lt;/div&gt;", (Object)sb.toString());
    }
}

