/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.net.ssl;

import java.security.KeyStore;
import org.apache.logging.log4j.core.net.ssl.KeyStoreConfiguration;
import org.apache.logging.log4j.core.net.ssl.MemoryPasswordProvider;
import org.apache.logging.log4j.core.net.ssl.PasswordProvider;
import org.apache.logging.log4j.core.net.ssl.StoreConfigurationException;
import org.apache.logging.log4j.core.net.ssl.TestConstants;
import org.junit.Assert;
import org.junit.Test;

public class KeyStoreConfigurationTest {
    @Test(expected=StoreConfigurationException.class)
    public void loadEmptyConfigurationDeprecated() throws StoreConfigurationException {
        KeyStoreConfiguration ksc = new KeyStoreConfiguration(null, TestConstants.NULL_PWD, null, null);
        KeyStore ks = ksc.getKeyStore();
        Assert.assertTrue((ks == null ? 1 : 0) != 0);
    }

    @Test(expected=StoreConfigurationException.class)
    public void loadEmptyConfiguration() throws StoreConfigurationException {
        KeyStoreConfiguration ksc = new KeyStoreConfiguration(null, (PasswordProvider)new MemoryPasswordProvider(TestConstants.NULL_PWD), null, null);
        KeyStore ks = ksc.getKeyStore();
        Assert.assertTrue((ks == null ? 1 : 0) != 0);
    }

    @Test
    public void loadNotEmptyConfigurationDeprecated() throws StoreConfigurationException {
        KeyStoreConfiguration ksc = new KeyStoreConfiguration("src/test/resources/org/apache/logging/log4j/core/net/ssl/client.log4j2-keystore.jks", TestConstants.KEYSTORE_PWD(), "JKS", null);
        KeyStore ks = ksc.getKeyStore();
        Assert.assertTrue((ks != null ? 1 : 0) != 0);
    }

    @Test
    public void loadNotEmptyConfiguration() throws StoreConfigurationException {
        KeyStoreConfiguration ksc = new KeyStoreConfiguration("src/test/resources/org/apache/logging/log4j/core/net/ssl/client.log4j2-keystore.jks", (PasswordProvider)new MemoryPasswordProvider(TestConstants.KEYSTORE_PWD()), "JKS", null);
        KeyStore ks = ksc.getKeyStore();
        Assert.assertTrue((ks != null ? 1 : 0) != 0);
    }

    @Test
    public void returnTheSameKeyStoreAfterMultipleLoadsDeprecated() throws StoreConfigurationException {
        KeyStore ks2;
        KeyStoreConfiguration ksc = new KeyStoreConfiguration("src/test/resources/org/apache/logging/log4j/core/net/ssl/client.log4j2-keystore.jks", TestConstants.KEYSTORE_PWD(), "JKS", null);
        KeyStore ks = ksc.getKeyStore();
        Assert.assertTrue((ks == (ks2 = ksc.getKeyStore()) ? 1 : 0) != 0);
    }

    @Test
    public void returnTheSameKeyStoreAfterMultipleLoads() throws StoreConfigurationException {
        KeyStore ks2;
        KeyStoreConfiguration ksc = new KeyStoreConfiguration("src/test/resources/org/apache/logging/log4j/core/net/ssl/client.log4j2-keystore.jks", (PasswordProvider)new MemoryPasswordProvider(TestConstants.KEYSTORE_PWD()), "JKS", null);
        KeyStore ks = ksc.getKeyStore();
        Assert.assertTrue((ks == (ks2 = ksc.getKeyStore()) ? 1 : 0) != 0);
    }

    @Test(expected=StoreConfigurationException.class)
    public void wrongPasswordDeprecated() throws StoreConfigurationException {
        KeyStoreConfiguration ksc = new KeyStoreConfiguration("src/test/resources/org/apache/logging/log4j/core/net/ssl/client.log4j2-keystore.jks", "wrongPassword!", null, null);
        ksc.getKeyStore();
    }

    @Test(expected=StoreConfigurationException.class)
    public void wrongPassword() throws StoreConfigurationException {
        KeyStoreConfiguration ksc = new KeyStoreConfiguration("src/test/resources/org/apache/logging/log4j/core/net/ssl/client.log4j2-keystore.jks", (PasswordProvider)new MemoryPasswordProvider("wrongPassword!".toCharArray()), null, null);
        ksc.getKeyStore();
    }
}

