/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.filter;

import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.filter.AbstractFilter;
import org.apache.logging.log4j.core.filter.AbstractFilterable;
import org.apache.logging.log4j.core.filter.CompositeFilter;
import org.apache.logging.log4j.core.filter.ThresholdFilter;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class AbstractFilterableTest {
    MockedAbstractFilterable filterable;

    @Before
    public void setup() {
        this.filterable = new MockedAbstractFilterable();
    }

    @Test
    public void testAddSimpleFilter() throws Exception {
        ThresholdFilter filter = ThresholdFilter.createFilter((Level)Level.ERROR, null, null);
        this.filterable.addFilter((Filter)filter);
        Assert.assertSame((Object)filter, (Object)this.filterable.getFilter());
    }

    @Test
    public void testAddMultipleSimpleFilters() throws Exception {
        ThresholdFilter filter = ThresholdFilter.createFilter((Level)Level.ERROR, null, null);
        this.filterable.addFilter((Filter)filter);
        Assert.assertSame((Object)filter, (Object)this.filterable.getFilter());
        this.filterable.addFilter((Filter)filter);
        Assert.assertTrue((boolean)(this.filterable.getFilter() instanceof CompositeFilter));
        Assert.assertEquals((long)2L, (long)((CompositeFilter)this.filterable.getFilter()).getFilters().size());
    }

    @Test
    public void testAddMultipleEqualSimpleFilter() throws Exception {
        EqualFilter filter = new EqualFilter("test");
        this.filterable.addFilter((Filter)filter);
        Assert.assertSame((Object)((Object)filter), (Object)this.filterable.getFilter());
        this.filterable.addFilter((Filter)filter);
        Assert.assertTrue((boolean)(this.filterable.getFilter() instanceof CompositeFilter));
        Assert.assertEquals((long)2L, (long)((CompositeFilter)this.filterable.getFilter()).getFilters().size());
    }

    @Test
    public void testAddCompositeFilter() throws Exception {
        ThresholdFilter filter1 = ThresholdFilter.createFilter((Level)Level.ERROR, null, null);
        ThresholdFilter filter2 = ThresholdFilter.createFilter((Level)Level.ERROR, null, null);
        CompositeFilter compositeFilter = CompositeFilter.createFilters((Filter[])new Filter[]{filter1, filter2});
        this.filterable.addFilter((Filter)compositeFilter);
        Assert.assertSame((Object)compositeFilter, (Object)this.filterable.getFilter());
    }

    @Test
    public void testAddMultipleCompositeFilters() throws Exception {
        ThresholdFilter filter1 = ThresholdFilter.createFilter((Level)Level.ERROR, null, null);
        ThresholdFilter filter2 = ThresholdFilter.createFilter((Level)Level.ERROR, null, null);
        ThresholdFilter filter3 = ThresholdFilter.createFilter((Level)Level.ERROR, null, null);
        CompositeFilter compositeFilter = CompositeFilter.createFilters((Filter[])new Filter[]{filter1, filter2, filter3});
        this.filterable.addFilter((Filter)compositeFilter);
        Assert.assertSame((Object)compositeFilter, (Object)this.filterable.getFilter());
        this.filterable.addFilter((Filter)compositeFilter);
        Assert.assertTrue((boolean)(this.filterable.getFilter() instanceof CompositeFilter));
        Assert.assertEquals((long)6L, (long)((CompositeFilter)this.filterable.getFilter()).getFilters().size());
    }

    @Test
    public void testAddSimpleFilterAndCompositeFilter() throws Exception {
        ThresholdFilter filter1 = ThresholdFilter.createFilter((Level)Level.ERROR, null, null);
        ThresholdFilter filter2 = ThresholdFilter.createFilter((Level)Level.ERROR, null, null);
        ThresholdFilter notInCompositeFilterFilter = ThresholdFilter.createFilter((Level)Level.ERROR, null, null);
        CompositeFilter compositeFilter = CompositeFilter.createFilters((Filter[])new Filter[]{filter1, filter2});
        this.filterable.addFilter((Filter)notInCompositeFilterFilter);
        Assert.assertSame((Object)notInCompositeFilterFilter, (Object)this.filterable.getFilter());
        this.filterable.addFilter((Filter)compositeFilter);
        Assert.assertTrue((boolean)(this.filterable.getFilter() instanceof CompositeFilter));
        Assert.assertEquals((long)2L, (long)((CompositeFilter)this.filterable.getFilter()).getFilters().size());
    }

    @Test
    public void testAddCompositeFilterAndSimpleFilter() throws Exception {
        ThresholdFilter filter1 = ThresholdFilter.createFilter((Level)Level.ERROR, null, null);
        ThresholdFilter filter2 = ThresholdFilter.createFilter((Level)Level.ERROR, null, null);
        ThresholdFilter notInCompositeFilterFilter = ThresholdFilter.createFilter((Level)Level.ERROR, null, null);
        CompositeFilter compositeFilter = CompositeFilter.createFilters((Filter[])new Filter[]{filter1, filter2});
        this.filterable.addFilter((Filter)compositeFilter);
        Assert.assertSame((Object)compositeFilter, (Object)this.filterable.getFilter());
        this.filterable.addFilter((Filter)notInCompositeFilterFilter);
        Assert.assertTrue((boolean)(this.filterable.getFilter() instanceof CompositeFilter));
        Assert.assertEquals((long)3L, (long)((CompositeFilter)this.filterable.getFilter()).getFilters().size());
    }

    @Test
    public void testRemoveSimpleFilterFromSimpleFilter() throws Exception {
        ThresholdFilter filter = ThresholdFilter.createFilter((Level)Level.ERROR, null, null);
        this.filterable.addFilter((Filter)filter);
        this.filterable.removeFilter((Filter)filter);
        Assert.assertNull((Object)this.filterable.getFilter());
    }

    @Test
    public void testRemoveSimpleEqualFilterFromSimpleFilter() throws Exception {
        EqualFilter filterOriginal = new EqualFilter("test");
        EqualFilter filterCopy = new EqualFilter("test");
        this.filterable.addFilter((Filter)filterOriginal);
        this.filterable.removeFilter((Filter)filterCopy);
        Assert.assertNull((Object)this.filterable.getFilter());
    }

    @Test
    public void testRemoveSimpleEqualFilterFromTwoSimpleFilters() throws Exception {
        EqualFilter filterOriginal = new EqualFilter("test");
        EqualFilter filterCopy = new EqualFilter("test");
        this.filterable.addFilter((Filter)filterOriginal);
        this.filterable.addFilter((Filter)filterOriginal);
        this.filterable.removeFilter((Filter)filterCopy);
        Assert.assertSame((Object)((Object)filterOriginal), (Object)this.filterable.getFilter());
        this.filterable.removeFilter((Filter)filterCopy);
        Assert.assertNull((Object)this.filterable.getFilter());
    }

    @Test
    public void testRemoveSimpleEqualFilterFromMultipleSimpleFilters() throws Exception {
        EqualFilter filterOriginal = new EqualFilter("test");
        EqualFilter filterCopy = new EqualFilter("test");
        this.filterable.addFilter((Filter)filterOriginal);
        this.filterable.addFilter((Filter)filterOriginal);
        this.filterable.addFilter((Filter)filterCopy);
        this.filterable.removeFilter((Filter)filterCopy);
        Assert.assertTrue((boolean)(this.filterable.getFilter() instanceof CompositeFilter));
        Assert.assertEquals((long)2L, (long)((CompositeFilter)this.filterable.getFilter()).getFilters().size());
        this.filterable.removeFilter((Filter)filterCopy);
        Assert.assertEquals((Object)((Object)filterOriginal), (Object)this.filterable.getFilter());
        this.filterable.removeFilter((Filter)filterOriginal);
        Assert.assertNull((Object)this.filterable.getFilter());
    }

    @Test
    public void testRemoveNullFromSingleSimpleFilter() throws Exception {
        ThresholdFilter filter = ThresholdFilter.createFilter((Level)Level.ERROR, null, null);
        this.filterable.addFilter((Filter)filter);
        this.filterable.removeFilter(null);
        Assert.assertSame((Object)filter, (Object)this.filterable.getFilter());
    }

    @Test
    public void testRemoveNonExistingFilterFromSingleSimpleFilter() throws Exception {
        ThresholdFilter filter = ThresholdFilter.createFilter((Level)Level.ERROR, null, null);
        ThresholdFilter newFilter = ThresholdFilter.createFilter((Level)Level.WARN, null, null);
        this.filterable.addFilter((Filter)filter);
        this.filterable.removeFilter((Filter)newFilter);
        Assert.assertSame((Object)filter, (Object)this.filterable.getFilter());
    }

    @Test
    public void testRemoveSimpleFilterFromCompositeFilter() {
        ThresholdFilter filter1 = ThresholdFilter.createFilter((Level)Level.ERROR, null, null);
        ThresholdFilter filter2 = ThresholdFilter.createFilter((Level)Level.ERROR, null, null);
        CompositeFilter compositeFilter = CompositeFilter.createFilters((Filter[])new Filter[]{filter1, filter2});
        this.filterable.addFilter((Filter)compositeFilter);
        this.filterable.removeFilter((Filter)filter1);
        Assert.assertFalse((boolean)(this.filterable.getFilter() instanceof CompositeFilter));
        Assert.assertEquals((Object)filter2, (Object)this.filterable.getFilter());
    }

    @Test
    public void testRemoveSimpleFilterFromCompositeAndSimpleFilter() {
        ThresholdFilter filter1 = ThresholdFilter.createFilter((Level)Level.ERROR, null, null);
        ThresholdFilter filter2 = ThresholdFilter.createFilter((Level)Level.ERROR, null, null);
        CompositeFilter compositeFilter = CompositeFilter.createFilters((Filter[])new Filter[]{filter1, filter2});
        ThresholdFilter anotherFilter = ThresholdFilter.createFilter((Level)Level.WARN, null, null);
        this.filterable.addFilter((Filter)compositeFilter);
        this.filterable.addFilter((Filter)anotherFilter);
        this.filterable.removeFilter((Filter)anotherFilter);
        Assert.assertTrue((boolean)(this.filterable.getFilter() instanceof CompositeFilter));
        Assert.assertEquals((long)2L, (long)((CompositeFilter)this.filterable.getFilter()).getFilters().size());
    }

    @Test
    public void testRemoveCompositeFilterFromCompositeFilter() {
        ThresholdFilter filter1 = ThresholdFilter.createFilter((Level)Level.ERROR, null, null);
        ThresholdFilter filter2 = ThresholdFilter.createFilter((Level)Level.ERROR, null, null);
        CompositeFilter compositeFilter = CompositeFilter.createFilters((Filter[])new Filter[]{filter1, filter2});
        this.filterable.addFilter((Filter)compositeFilter);
        this.filterable.removeFilter((Filter)compositeFilter);
        Assert.assertNull((Object)this.filterable.getFilter());
    }

    @Test
    public void testRemoveFiltersFromComposite() {
        ThresholdFilter filter1 = ThresholdFilter.createFilter((Level)Level.ERROR, null, null);
        ThresholdFilter filter2 = ThresholdFilter.createFilter((Level)Level.ERROR, null, null);
        CompositeFilter compositeFilter = CompositeFilter.createFilters((Filter[])new Filter[]{filter1, filter2});
        ThresholdFilter anotherFilter = ThresholdFilter.createFilter((Level)Level.WARN, null, null);
        this.filterable.addFilter((Filter)compositeFilter);
        this.filterable.addFilter((Filter)anotherFilter);
        Assert.assertEquals((long)3L, (long)((CompositeFilter)this.filterable.getFilter()).getFilters().size());
        this.filterable.removeFilter((Filter)filter1);
        Assert.assertEquals((long)2L, (long)((CompositeFilter)this.filterable.getFilter()).getFilters().size());
        this.filterable.removeFilter((Filter)filter2);
        Assert.assertSame((Object)anotherFilter, (Object)this.filterable.getFilter());
    }

    private class EqualFilter
    extends AbstractFilter {
        private final String key;

        public EqualFilter(String key) {
            this.key = key;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof EqualFilter)) {
                return false;
            }
            EqualFilter that = (EqualFilter)((Object)o);
            return !(this.key != null ? !this.key.equals(that.key) : that.key != null);
        }

        public int hashCode() {
            return this.key != null ? this.key.hashCode() : 0;
        }
    }

    private class MockedAbstractFilterable
    extends AbstractFilterable {
        private MockedAbstractFilterable() {
        }
    }
}

