/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.async;

import java.util.Stack;
import java.util.concurrent.CountDownLatch;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.categories.AsyncLoggers;
import org.apache.logging.log4j.core.async.BlockingAppender;
import org.apache.logging.log4j.core.async.QueueFullAbstractTest;
import org.apache.logging.log4j.junit.LoggerContextRule;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.BlockJUnit4ClassRunner;

@RunWith(value=BlockJUnit4ClassRunner.class)
@Category(value={AsyncLoggers.class})
public class QueueFullAsyncAppenderTest
extends QueueFullAbstractTest {
    @Rule
    public LoggerContextRule context = new LoggerContextRule("log4j2-queueFullAsyncAppender.xml");

    @BeforeClass
    public static void beforeClass() {
        System.setProperty("log4j.configurationFile", "log4j2-queueFullAsyncAppender.xml");
    }

    @Before
    public void before() throws Exception {
        this.blockingAppender = this.context.getRequiredAppender("Blocking", BlockingAppender.class);
    }

    @Test(timeout=5000L)
    public void testNormalQueueFullKeepsMessagesInOrder() throws InterruptedException {
        Logger logger = LogManager.getLogger(this.getClass());
        this.blockingAppender.countDownLatch = new CountDownLatch(1);
        this.unlocker = new QueueFullAbstractTest.Unlocker(new CountDownLatch(129));
        this.unlocker.start();
        QueueFullAsyncAppenderTest.asyncAppenderTest(logger, this.unlocker, this.blockingAppender);
    }

    static void asyncAppenderTest(Logger logger, QueueFullAbstractTest.Unlocker unlocker, BlockingAppender blockingAppender) {
        for (int i = 0; i < 130; ++i) {
            QueueFullAsyncAppenderTest.TRACE("Test logging message " + i + ". Remaining capacity=" + QueueFullAsyncAppenderTest.asyncRemainingCapacity(logger));
            QueueFullAsyncAppenderTest.TRACE("Test decrementing unlocker countdown latch. Count=" + unlocker.countDownLatch.getCount());
            unlocker.countDownLatch.countDown();
            String param = "I'm innocent";
            logger.info((Message)new ParameterizedMessage("logging innocent object #{} {}", (Object)i, (Object)"I'm innocent"));
        }
        QueueFullAsyncAppenderTest.TRACE("Before stop() blockingAppender.logEvents.count=" + blockingAppender.logEvents.size());
        while (blockingAppender.logEvents.size() < 130) {
            Thread.yield();
        }
        QueueFullAsyncAppenderTest.TRACE("After  stop() blockingAppender.logEvents.count=" + blockingAppender.logEvents.size());
        Stack actual = QueueFullAsyncAppenderTest.transform(blockingAppender.logEvents);
        for (int i = 0; i < 130; ++i) {
            Assert.assertEquals((Object)("logging innocent object #" + i + " I'm innocent"), actual.pop());
        }
        Assert.assertTrue((boolean)actual.isEmpty());
    }
}

