/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.appender;

import java.lang.reflect.Field;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.appender.AsyncAppender;
import org.apache.logging.log4j.core.async.DefaultAsyncQueueFullPolicy;
import org.apache.logging.log4j.core.async.EventRoute;
import org.apache.logging.log4j.junit.LoggerContextRule;
import org.apache.logging.log4j.test.appender.BlockingAppender;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;

public class AsyncAppenderQueueFullPolicyTest {
    private static final String CONFIG = "log4j-asynch-queue-full.xml";
    @ClassRule
    public static LoggerContextRule context = new LoggerContextRule("log4j-asynch-queue-full.xml");
    private BlockingAppender blockingAppender;
    private AsyncAppender asyncAppender;
    private CountingAsyncQueueFullPolicy policy;

    @Before
    public void before() throws Exception {
        this.blockingAppender = context.getAppender("Block", BlockingAppender.class);
        this.asyncAppender = context.getAppender("Async", AsyncAppender.class);
        Field field = AsyncAppender.class.getDeclaredField("asyncQueueFullPolicy");
        field.setAccessible(true);
        this.policy = new CountingAsyncQueueFullPolicy();
        field.set(this.asyncAppender, (Object)this.policy);
        this.policy.queueFull.set(0L);
    }

    @After
    public void after() {
        this.blockingAppender.running = false;
        this.policy.queueFull.set(0L);
    }

    @Test
    public void testRouter() throws Exception {
        Logger logger = LogManager.getLogger(AsyncAppenderQueueFullPolicyTest.class);
        Assert.assertEquals((long)4L, (long)this.asyncAppender.getQueueCapacity());
        logger.error("event 1 - gets taken off the queue");
        logger.warn("event 2");
        logger.info("event 3");
        logger.info("event 4");
        while (this.asyncAppender.getQueueRemainingCapacity() == 0) {
            Thread.yield();
        }
        logger.info("event 5 - now the queue is full");
        Assert.assertEquals((String)"queue remaining capacity", (long)0L, (long)this.asyncAppender.getQueueRemainingCapacity());
        Assert.assertEquals((String)"EventRouter invocations", (long)0L, (long)this.policy.queueFull.get());
        Thread release = new Thread("AsyncAppenderReleaser"){

            @Override
            public void run() {
                while (((AsyncAppenderQueueFullPolicyTest)AsyncAppenderQueueFullPolicyTest.this).policy.queueFull.get() == 0L) {
                    try {
                        Thread.sleep(10L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                ((AsyncAppenderQueueFullPolicyTest)AsyncAppenderQueueFullPolicyTest.this).blockingAppender.running = false;
            }
        };
        release.setDaemon(true);
        release.start();
        logger.fatal("this blocks until queue space available");
        Assert.assertEquals((long)1L, (long)this.policy.queueFull.get());
    }

    public static class CountingAsyncQueueFullPolicy
    extends DefaultAsyncQueueFullPolicy {
        AtomicLong queueFull = new AtomicLong();

        public EventRoute getRoute(long backgroundThreadId, Level level) {
            this.queueFull.incrementAndGet();
            return EventRoute.ENQUEUE;
        }
    }
}

