/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.pattern;

import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.ThreadContext;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.impl.Log4jLogEvent;
import org.apache.logging.log4j.core.pattern.MdcPatternConverter;
import org.apache.logging.log4j.junit.ThreadContextMapRule;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.SimpleMessage;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

public class MdcPatternConverterTest {
    @Rule
    public final ThreadContextMapRule threadContextRule = new ThreadContextMapRule();

    @Before
    public void setup() {
        ThreadContext.put((String)"subject", (String)"I");
        ThreadContext.put((String)"verb", (String)"love");
        ThreadContext.put((String)"object", (String)"Log4j");
    }

    @Test
    public void testConverter() {
        SimpleMessage msg = new SimpleMessage("Hello");
        MdcPatternConverter converter = MdcPatternConverter.newInstance(null);
        Log4jLogEvent event = Log4jLogEvent.newBuilder().setLoggerName("MyLogger").setLevel(Level.DEBUG).setMessage((Message)msg).build();
        StringBuilder sb = new StringBuilder();
        converter.format((LogEvent)event, sb);
        String str = sb.toString();
        String expected = "{object=Log4j, subject=I, verb=love}";
        Assert.assertTrue((String)("Incorrect result. Expected {object=Log4j, subject=I, verb=love}, actual " + str), (boolean)str.equals("{object=Log4j, subject=I, verb=love}"));
    }

    @Test
    public void testConverterWithExistingData() {
        SimpleMessage msg = new SimpleMessage("Hello");
        MdcPatternConverter converter = MdcPatternConverter.newInstance(null);
        Log4jLogEvent event = Log4jLogEvent.newBuilder().setLoggerName("MyLogger").setLevel(Level.DEBUG).setMessage((Message)msg).build();
        StringBuilder sb = new StringBuilder();
        sb.append("prefix ");
        converter.format((LogEvent)event, sb);
        String str = sb.toString();
        String expected = "prefix {object=Log4j, subject=I, verb=love}";
        Assert.assertTrue((String)("Incorrect result. Expected prefix {object=Log4j, subject=I, verb=love}, actual " + str), (boolean)str.equals("prefix {object=Log4j, subject=I, verb=love}"));
    }

    @Test
    public void testConverterFullEmpty() {
        ThreadContext.clearMap();
        SimpleMessage msg = new SimpleMessage("Hello");
        MdcPatternConverter converter = MdcPatternConverter.newInstance(null);
        Log4jLogEvent event = Log4jLogEvent.newBuilder().setLoggerName("MyLogger").setLevel(Level.DEBUG).setMessage((Message)msg).build();
        StringBuilder sb = new StringBuilder();
        converter.format((LogEvent)event, sb);
        String str = sb.toString();
        String expected = "{}";
        Assert.assertTrue((String)("Incorrect result. Expected {}, actual " + str), (boolean)str.equals("{}"));
    }

    @Test
    public void testConverterFullSingle() {
        ThreadContext.clearMap();
        ThreadContext.put((String)"foo", (String)"bar");
        SimpleMessage msg = new SimpleMessage("Hello");
        MdcPatternConverter converter = MdcPatternConverter.newInstance(null);
        Log4jLogEvent event = Log4jLogEvent.newBuilder().setLoggerName("MyLogger").setLevel(Level.DEBUG).setMessage((Message)msg).build();
        StringBuilder sb = new StringBuilder();
        converter.format((LogEvent)event, sb);
        String str = sb.toString();
        String expected = "{foo=bar}";
        Assert.assertTrue((String)("Incorrect result. Expected {foo=bar}, actual " + str), (boolean)str.equals("{foo=bar}"));
    }

    @Test
    public void testConverterWithKey() {
        SimpleMessage msg = new SimpleMessage("Hello");
        String[] options = new String[]{"object"};
        MdcPatternConverter converter = MdcPatternConverter.newInstance((String[])options);
        Log4jLogEvent event = Log4jLogEvent.newBuilder().setLoggerName("MyLogger").setLevel(Level.DEBUG).setMessage((Message)msg).build();
        StringBuilder sb = new StringBuilder();
        converter.format((LogEvent)event, sb);
        String str = sb.toString();
        String expected = "Log4j";
        Assert.assertEquals((Object)"Log4j", (Object)str);
    }

    @Test
    public void testConverterWithKeys() {
        SimpleMessage msg = new SimpleMessage("Hello");
        String[] options = new String[]{"object, subject"};
        MdcPatternConverter converter = MdcPatternConverter.newInstance((String[])options);
        Log4jLogEvent event = Log4jLogEvent.newBuilder().setLoggerName("MyLogger").setLevel(Level.DEBUG).setMessage((Message)msg).build();
        StringBuilder sb = new StringBuilder();
        converter.format((LogEvent)event, sb);
        String str = sb.toString();
        String expected = "{object=Log4j, subject=I}";
        Assert.assertEquals((Object)"{object=Log4j, subject=I}", (Object)str);
    }

    @Test
    public void testConverterWithKeysAndPrefix() {
        SimpleMessage msg = new SimpleMessage("Hello");
        String[] options = new String[]{"object, subject"};
        MdcPatternConverter converter = MdcPatternConverter.newInstance((String[])options);
        Log4jLogEvent event = Log4jLogEvent.newBuilder().setLoggerName("MyLogger").setLevel(Level.DEBUG).setMessage((Message)msg).build();
        StringBuilder sb = new StringBuilder();
        sb.append("prefix ");
        converter.format((LogEvent)event, sb);
        String str = sb.toString();
        String expected = "prefix {object=Log4j, subject=I}";
        Assert.assertEquals((Object)"prefix {object=Log4j, subject=I}", (Object)str);
    }

    @Test
    public void testConverterWithKeysSinglePresent() {
        SimpleMessage msg = new SimpleMessage("Hello");
        String[] options = new String[]{"object, notpresent"};
        MdcPatternConverter converter = MdcPatternConverter.newInstance((String[])options);
        Log4jLogEvent event = Log4jLogEvent.newBuilder().setLoggerName("MyLogger").setLevel(Level.DEBUG).setMessage((Message)msg).build();
        StringBuilder sb = new StringBuilder();
        converter.format((LogEvent)event, sb);
        String str = sb.toString();
        String expected = "{object=Log4j}";
        Assert.assertEquals((Object)"{object=Log4j}", (Object)str);
    }

    @Test
    public void testConverterWithKeysNonePresent() {
        ThreadContext.clearMap();
        SimpleMessage msg = new SimpleMessage("Hello");
        String[] options = new String[]{"object, subject"};
        MdcPatternConverter converter = MdcPatternConverter.newInstance((String[])options);
        Log4jLogEvent event = Log4jLogEvent.newBuilder().setLoggerName("MyLogger").setLevel(Level.DEBUG).setMessage((Message)msg).build();
        StringBuilder sb = new StringBuilder();
        converter.format((LogEvent)event, sb);
        String str = sb.toString();
        String expected = "{}";
        Assert.assertEquals((Object)"{}", (Object)str);
    }
}

