/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.pattern;

import java.util.List;
import org.apache.logging.log4j.core.Logger;
import org.apache.logging.log4j.junit.LoggerContextRule;
import org.apache.logging.log4j.test.appender.ListAppender;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;

public class CallerInformationTest {
    @ClassRule
    public static LoggerContextRule context = new LoggerContextRule("log4j2-calling-class.xml");

    @Test
    public void testClassLogger() throws Exception {
        ListAppender app = context.getListAppender("Class").clear();
        Logger logger = context.getLogger("ClassLogger");
        logger.info("Ignored message contents.");
        logger.warn("Verifying the caller class is still correct.");
        logger.error("Hopefully nobody breaks me!");
        List<String> messages = app.getMessages();
        Assert.assertEquals((String)"Incorrect number of messages.", (long)3L, (long)messages.size());
        for (String message : messages) {
            Assert.assertEquals((String)"Incorrect caller class name.", (Object)this.getClass().getName(), (Object)message);
        }
    }

    @Test
    public void testMethodLogger() throws Exception {
        ListAppender app = context.getListAppender("Method").clear();
        Logger logger = context.getLogger("MethodLogger");
        logger.info("More messages.");
        logger.warn("CATASTROPHE INCOMING!");
        logger.error("ZOMBIES!!!");
        logger.fatal("brains~~~");
        logger.info("Itchy. Tasty.");
        List<String> messages = app.getMessages();
        Assert.assertEquals((String)"Incorrect number of messages.", (long)5L, (long)messages.size());
        for (String message : messages) {
            Assert.assertEquals((String)"Incorrect caller method name.", (Object)"testMethodLogger", (Object)message);
        }
    }
}

