/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.parser;

import java.nio.charset.StandardCharsets;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.parser.LogEventParserTest;
import org.apache.logging.log4j.core.parser.ParseException;
import org.apache.logging.log4j.core.parser.XmlLogEventParser;
import org.junit.Before;
import org.junit.Test;

public class XmlLogEventParserTest
extends LogEventParserTest {
    private XmlLogEventParser parser;
    private static final String XML = "<Event xmlns=\"http://logging.apache.org/log4j/2.0/events\"\n       timeMillis=\"1493121664118\"\n       level=\"INFO\"\n       loggerName=\"HelloWorld\"\n       endOfBatch=\"false\"\n       thread=\"main\"\n       loggerFqcn=\"org.apache.logging.log4j.spi.AbstractLogger\"\n       threadId=\"1\"\n       threadPriority=\"5\">\n  <Instant epochSecond=\"1493121664\" nanoOfSecond=\"118000000\"/>\n  <Marker name=\"child\">\n    <Parents>\n      <Marker name=\"parent\">\n        <Parents>\n          <Marker name=\"grandparent\"/>\n        </Parents>\n      </Marker>\n    </Parents>\n  </Marker>\n  <Message>Hello, world!</Message>\n  <ContextMap>\n    <item key=\"bar\" value=\"BAR\"/>\n    <item key=\"foo\" value=\"FOO\"/>\n  </ContextMap>\n  <ContextStack>\n    <ContextStackItem>one</ContextStackItem>\n    <ContextStackItem>two</ContextStackItem>\n  </ContextStack>\n  <Source\n      class=\"logtest.Main\"\n      method=\"main\"\n      file=\"Main.java\"\n      line=\"29\"/>\n  <Thrown commonElementCount=\"0\" message=\"error message\" name=\"java.lang.RuntimeException\">\n    <ExtendedStackTrace>\n      <ExtendedStackTraceItem\n          class=\"logtest.Main\"\n          method=\"main\"\n          file=\"Main.java\"\n          line=\"29\"\n          exact=\"true\"\n          location=\"classes/\"\n          version=\"?\"/>\n    </ExtendedStackTrace>\n  </Thrown>\n</Event>";

    @Before
    public void setup() {
        this.parser = new XmlLogEventParser();
    }

    @Test
    public void testString() throws ParseException {
        LogEvent logEvent = this.parser.parseFrom(XML);
        this.assertLogEvent(logEvent);
    }

    @Test(expected=ParseException.class)
    public void testStringEmpty() throws ParseException {
        this.parser.parseFrom("");
    }

    @Test(expected=ParseException.class)
    public void testStringInvalidXml() throws ParseException {
        this.parser.parseFrom("foobar");
    }

    @Test
    public void testEmptyObject() throws ParseException {
        this.parser.parseFrom("<Event></Event>");
    }

    @Test(expected=ParseException.class)
    public void testStringWrongPropertyType() throws ParseException {
        this.parser.parseFrom("<Event><Instant epochSecond=\"bar\">foobar</Instant></Event>");
    }

    @Test
    public void testTimeMillisIgnored() throws ParseException {
        this.parser.parseFrom("<Event><timeMillis>foobar</timeMillis></Event>");
    }

    @Test
    public void testStringIgnoreInvalidProperty() throws ParseException {
        this.parser.parseFrom("<Event><foo>bar</foo></Event>");
    }

    @Test
    public void testByteArray() throws ParseException {
        LogEvent logEvent = this.parser.parseFrom(XML.getBytes(StandardCharsets.UTF_8));
        this.assertLogEvent(logEvent);
    }

    @Test
    public void testByteArrayOffsetLength() throws ParseException {
        byte[] bytes = "abc<Event xmlns=\"http://logging.apache.org/log4j/2.0/events\"\n       timeMillis=\"1493121664118\"\n       level=\"INFO\"\n       loggerName=\"HelloWorld\"\n       endOfBatch=\"false\"\n       thread=\"main\"\n       loggerFqcn=\"org.apache.logging.log4j.spi.AbstractLogger\"\n       threadId=\"1\"\n       threadPriority=\"5\">\n  <Instant epochSecond=\"1493121664\" nanoOfSecond=\"118000000\"/>\n  <Marker name=\"child\">\n    <Parents>\n      <Marker name=\"parent\">\n        <Parents>\n          <Marker name=\"grandparent\"/>\n        </Parents>\n      </Marker>\n    </Parents>\n  </Marker>\n  <Message>Hello, world!</Message>\n  <ContextMap>\n    <item key=\"bar\" value=\"BAR\"/>\n    <item key=\"foo\" value=\"FOO\"/>\n  </ContextMap>\n  <ContextStack>\n    <ContextStackItem>one</ContextStackItem>\n    <ContextStackItem>two</ContextStackItem>\n  </ContextStack>\n  <Source\n      class=\"logtest.Main\"\n      method=\"main\"\n      file=\"Main.java\"\n      line=\"29\"/>\n  <Thrown commonElementCount=\"0\" message=\"error message\" name=\"java.lang.RuntimeException\">\n    <ExtendedStackTrace>\n      <ExtendedStackTraceItem\n          class=\"logtest.Main\"\n          method=\"main\"\n          file=\"Main.java\"\n          line=\"29\"\n          exact=\"true\"\n          location=\"classes/\"\n          version=\"?\"/>\n    </ExtendedStackTrace>\n  </Thrown>\n</Event>def".getBytes(StandardCharsets.UTF_8);
        LogEvent logEvent = this.parser.parseFrom(bytes, 3, bytes.length - 6);
        this.assertLogEvent(logEvent);
    }
}

