/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.jackson;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import java.io.IOException;
import org.apache.logging.log4j.categories.Layouts;
import org.apache.logging.log4j.core.jackson.Log4jJsonModule;
import org.apache.logging.log4j.core.jackson.Log4jJsonObjectMapper;
import org.apache.logging.log4j.core.jackson.Log4jStackTraceElementDeserializer;
import org.apache.logging.log4j.core.jackson.Log4jXmlObjectMapper;
import org.apache.logging.log4j.core.jackson.Log4jYamlObjectMapper;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={Layouts.Json.class})
public class StackTraceElementMixInTest {
    @Test
    public void testLog4jJsonObjectMapper() throws Exception {
        this.roundtrip((ObjectMapper)new Log4jJsonObjectMapper());
    }

    @Test
    public void testLog4jYamlObjectMapper() throws Exception {
        this.roundtrip((ObjectMapper)new Log4jYamlObjectMapper());
    }

    private void roundtrip(ObjectMapper mapper) throws JsonProcessingException, IOException, JsonParseException, JsonMappingException {
        StackTraceElement expected = new StackTraceElement("package.SomeClass", "someMethod", "SomeClass.java", 123);
        String s = mapper.writeValueAsString((Object)expected);
        StackTraceElement actual = (StackTraceElement)mapper.readValue(s, StackTraceElement.class);
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testLog4jXmlObjectMapper() throws Exception {
        this.roundtrip((ObjectMapper)new Log4jXmlObjectMapper());
    }

    protected String aposToQuotes(String json) {
        return json.replace("'", "\"");
    }

    @Test
    public void testFromJsonWithSimpleModule() throws Exception {
        ObjectMapper mapper = new ObjectMapper();
        SimpleModule module = new SimpleModule();
        module.addDeserializer(StackTraceElement.class, (JsonDeserializer)new Log4jStackTraceElementDeserializer());
        mapper.registerModule((Module)module);
        StackTraceElement expected = new StackTraceElement("package.SomeClass", "someMethod", "SomeClass.java", 123);
        String s = this.aposToQuotes("{'class':'package.SomeClass','method':'someMethod','file':'SomeClass.java','line':123}");
        StackTraceElement actual = (StackTraceElement)mapper.readValue(s, StackTraceElement.class);
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testFromJsonWithLog4jModule() throws Exception {
        ObjectMapper mapper = new ObjectMapper();
        boolean encodeThreadContextAsList = false;
        Log4jJsonModule module = new Log4jJsonModule(false, true, false, false);
        module.addDeserializer(StackTraceElement.class, (JsonDeserializer)new Log4jStackTraceElementDeserializer());
        mapper.registerModule((Module)module);
        StackTraceElement expected = new StackTraceElement("package.SomeClass", "someMethod", "SomeClass.java", 123);
        String s = this.aposToQuotes("{'class':'package.SomeClass','method':'someMethod','file':'SomeClass.java','line':123}");
        StackTraceElement actual = (StackTraceElement)mapper.readValue(s, StackTraceElement.class);
        Assert.assertEquals((Object)expected, (Object)actual);
    }
}

