/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.impl;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.CoreLoggerContexts;
import org.apache.logging.log4j.core.impl.Log4jLogEvent;
import org.apache.logging.log4j.core.util.DummyNanoClock;
import org.apache.logging.log4j.core.util.NanoClock;
import org.apache.logging.log4j.core.util.SystemNanoClock;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class Log4jLogEventNanoTimeTest {
    @BeforeClass
    public static void beforeClass() {
        System.setProperty("log4j.configurationFile", "NanoTimeToFileTest.xml");
    }

    @AfterClass
    public static void afterClass() {
        System.setProperty("Log4jContextSelector", "");
    }

    @Test
    public void testLog4jLogEventUsesNanoTimeClock() throws Exception {
        String line2;
        String line1;
        File file = new File("target", "NanoTimeToFileTest.log");
        file.delete();
        Logger log = LogManager.getLogger((String)"com.foo.Bar");
        long before = System.nanoTime();
        log.info("Use actual System.nanoTime()");
        Assert.assertTrue((String)"using SystemNanoClock", (boolean)(Log4jLogEvent.getNanoClock() instanceof SystemNanoClock));
        long DUMMYNANOTIME = 123L;
        Log4jLogEvent.setNanoClock((NanoClock)new DummyNanoClock(123L));
        log.info("Use dummy nano clock");
        Assert.assertTrue((String)"using SystemNanoClock", (boolean)(Log4jLogEvent.getNanoClock() instanceof DummyNanoClock));
        CoreLoggerContexts.stopLoggerContext(file);
        try (BufferedReader reader = new BufferedReader(new FileReader(file));){
            line1 = reader.readLine();
            line2 = reader.readLine();
        }
        file.delete();
        Assert.assertNotNull((String)"line1", (Object)line1);
        Assert.assertNotNull((String)"line2", (Object)line2);
        String[] line1Parts = line1.split(" AND ");
        Assert.assertEquals((Object)"Use actual System.nanoTime()", (Object)line1Parts[2]);
        Assert.assertEquals((Object)line1Parts[0], (Object)line1Parts[1]);
        long loggedNanoTime = Long.parseLong(line1Parts[0]);
        Assert.assertTrue((String)"used system nano time", (loggedNanoTime - before < TimeUnit.SECONDS.toNanos(1L) ? 1 : 0) != 0);
        String[] line2Parts = line2.split(" AND ");
        Assert.assertEquals((Object)"Use dummy nano clock", (Object)line2Parts[2]);
        Assert.assertEquals((Object)String.valueOf(123L), (Object)line2Parts[0]);
        Assert.assertEquals((Object)String.valueOf(123L), (Object)line2Parts[1]);
    }
}

