/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.config.plugins.validation.validators;

import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.Node;
import org.apache.logging.log4j.core.config.NullConfiguration;
import org.apache.logging.log4j.core.config.plugins.util.PluginBuilder;
import org.apache.logging.log4j.core.config.plugins.util.PluginManager;
import org.apache.logging.log4j.core.config.plugins.util.PluginType;
import org.apache.logging.log4j.core.config.plugins.validation.HostAndPort;
import org.apache.logging.log4j.junit.StatusLoggerRule;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

public class ValidHostValidatorTest {
    @Rule
    public StatusLoggerRule rule = new StatusLoggerRule(Level.FATAL);
    private PluginType<HostAndPort> plugin;
    private Node node;

    @Before
    public void setUp() throws Exception {
        PluginManager manager = new PluginManager("Test");
        manager.collectPlugins();
        this.plugin = manager.getPluginType("HostAndPort");
        Assert.assertNotNull((String)"Rebuild this module to ensure annotation processing has been done.", this.plugin);
        this.node = new Node(null, "HostAndPort", this.plugin);
    }

    @Test
    public void testNullHost() throws Exception {
        Assert.assertNull((Object)this.buildPlugin());
    }

    @Test
    public void testInvalidIpAddress() throws Exception {
        this.node.getAttributes().put("host", "256.256.256.256");
        this.node.getAttributes().put("port", "1");
        HostAndPort plugin = this.buildPlugin();
        Assert.assertNull((String)("Expected null, but got: " + plugin), (Object)plugin);
    }

    @Test
    public void testLocalhost() throws Exception {
        this.node.getAttributes().put("host", "localhost");
        this.node.getAttributes().put("port", "1");
        HostAndPort hostAndPort = this.buildPlugin();
        Assert.assertNotNull((Object)hostAndPort);
        Assert.assertTrue((boolean)hostAndPort.isValid());
    }

    private HostAndPort buildPlugin() {
        return (HostAndPort)new PluginBuilder(this.plugin).withConfiguration((Configuration)new NullConfiguration()).withConfigurationNode(this.node).build();
    }
}

