/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.config.builder;

import java.net.URI;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.appender.ConsoleAppender;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.ConfigurationFactory;
import org.apache.logging.log4j.core.config.ConfigurationSource;
import org.apache.logging.log4j.core.config.builder.api.AppenderComponentBuilder;
import org.apache.logging.log4j.core.config.builder.api.ComponentBuilder;
import org.apache.logging.log4j.core.config.builder.api.ConfigurationBuilder;
import org.apache.logging.log4j.core.config.builder.api.FilterComponentBuilder;
import org.apache.logging.log4j.core.config.builder.api.LayoutComponentBuilder;
import org.apache.logging.log4j.core.config.builder.api.LoggerComponentBuilder;
import org.apache.logging.log4j.core.config.builder.api.RootLoggerComponentBuilder;
import org.apache.logging.log4j.core.config.builder.impl.BuiltConfiguration;

public class CustomConfigurationFactory
extends ConfigurationFactory {
    static Configuration addTestFixtures(String name, ConfigurationBuilder<BuiltConfiguration> builder) {
        builder.setConfigurationName(name);
        builder.setStatusLevel(Level.ERROR);
        builder.add(builder.newScriptFile("target/test-classes/scripts/filter.groovy").addIsWatched(true));
        builder.add((FilterComponentBuilder)builder.newFilter("ThresholdFilter", Filter.Result.ACCEPT, Filter.Result.NEUTRAL).addAttribute("level", Level.DEBUG));
        AppenderComponentBuilder appenderBuilder = (AppenderComponentBuilder)builder.newAppender("Stdout", "CONSOLE").addAttribute("target", (Enum)ConsoleAppender.Target.SYSTEM_OUT);
        appenderBuilder.add((LayoutComponentBuilder)builder.newLayout("PatternLayout").addAttribute("pattern", "%d [%t] %-5level: %msg%n%throwable"));
        appenderBuilder.add((FilterComponentBuilder)builder.newFilter("MarkerFilter", Filter.Result.DENY, Filter.Result.NEUTRAL).addAttribute("marker", "FLOW"));
        builder.add(appenderBuilder);
        AppenderComponentBuilder appenderBuilder2 = (AppenderComponentBuilder)builder.newAppender("Kafka", "Kafka").addAttribute("topic", "my-topic");
        appenderBuilder2.addComponent((ComponentBuilder)builder.newProperty("bootstrap.servers", "localhost:9092"));
        appenderBuilder2.add((LayoutComponentBuilder)((LayoutComponentBuilder)builder.newLayout("GelfLayout").addAttribute("host", "my-host")).addComponent((ComponentBuilder)builder.newKeyValuePair("extraField", "extraValue")));
        builder.add(appenderBuilder2);
        builder.add((LoggerComponentBuilder)((LoggerComponentBuilder)builder.newLogger("org.apache.logging.log4j", Level.DEBUG, true).add(builder.newAppenderRef("Stdout"))).addAttribute("additivity", false));
        builder.add((RootLoggerComponentBuilder)builder.newRootLogger(Level.ERROR).add(builder.newAppenderRef("Stdout")));
        builder.add(builder.newCustomLevel("Panic", 17));
        return (Configuration)builder.build();
    }

    public Configuration getConfiguration(LoggerContext loggerContext, ConfigurationSource source) {
        return this.getConfiguration(loggerContext, source.toString(), null);
    }

    public Configuration getConfiguration(LoggerContext loggerContext, String name, URI configLocation) {
        ConfigurationBuilder builder = CustomConfigurationFactory.newConfigurationBuilder();
        return CustomConfigurationFactory.addTestFixtures(name, (ConfigurationBuilder<BuiltConfiguration>)builder);
    }

    protected String[] getSupportedTypes() {
        return new String[]{"*"};
    }
}

