/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.async;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.categories.AsyncLoggers;
import org.apache.logging.log4j.core.CoreLoggerContexts;
import org.apache.logging.log4j.core.async.AsyncLogger;
import org.apache.logging.log4j.core.async.AsyncLoggerContextSelector;
import org.apache.logging.log4j.core.util.DummyNanoClock;
import org.apache.logging.log4j.core.util.NanoClock;
import org.apache.logging.log4j.core.util.SystemNanoClock;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={AsyncLoggers.class})
public class AsyncLoggerTestNanoTime {
    @BeforeClass
    public static void beforeClass() {
        System.setProperty("Log4jContextSelector", AsyncLoggerContextSelector.class.getName());
        System.setProperty("log4j.configurationFile", "NanoTimeToFileTest.xml");
    }

    @AfterClass
    public static void afterClass() {
        System.setProperty("Log4jContextSelector", "");
    }

    @Test
    public void testAsyncLogUsesNanoTimeClock() throws Exception {
        File file = new File("target", "NanoTimeToFileTest.log");
        file.delete();
        AsyncLogger log = (AsyncLogger)LogManager.getLogger((String)"com.foo.Bar");
        long before = System.nanoTime();
        log.info("Use actual System.nanoTime()");
        Assert.assertTrue((String)"using SystemNanoClock", (boolean)(log.getNanoClock() instanceof SystemNanoClock));
        long DUMMYNANOTIME = -53L;
        log.getContext().getConfiguration().setNanoClock((NanoClock)new DummyNanoClock(-53L));
        log.updateConfiguration(log.getContext().getConfiguration());
        log.updateConfiguration(log.getContext().getConfiguration());
        log.info("Use dummy nano clock");
        Assert.assertTrue((String)"using SystemNanoClock", (boolean)(log.getNanoClock() instanceof DummyNanoClock));
        CoreLoggerContexts.stopLoggerContext(file);
        BufferedReader reader = new BufferedReader(new FileReader(file));
        String line1 = reader.readLine();
        String line2 = reader.readLine();
        reader.close();
        file.delete();
        Assert.assertNotNull((String)"line1", (Object)line1);
        Assert.assertNotNull((String)"line2", (Object)line2);
        String[] line1Parts = line1.split(" AND ");
        Assert.assertEquals((Object)"Use actual System.nanoTime()", (Object)line1Parts[2]);
        Assert.assertEquals((Object)line1Parts[0], (Object)line1Parts[1]);
        long loggedNanoTime = Long.parseLong(line1Parts[0]);
        Assert.assertTrue((String)"used system nano time", (loggedNanoTime - before < TimeUnit.SECONDS.toNanos(1L) ? 1 : 0) != 0);
        String[] line2Parts = line2.split(" AND ");
        Assert.assertEquals((Object)"Use dummy nano clock", (Object)line2Parts[2]);
        Assert.assertEquals((Object)String.valueOf(-53L), (Object)line2Parts[0]);
        Assert.assertEquals((Object)String.valueOf(-53L), (Object)line2Parts[1]);
    }
}

