/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.async;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.categories.AsyncLoggers;
import org.apache.logging.log4j.core.CoreLoggerContexts;
import org.apache.logging.log4j.core.async.AsyncLoggerContextSelector;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={AsyncLoggers.class})
public class AsyncLoggerTestCachedThreadName {
    @BeforeClass
    public static void beforeClass() {
        System.setProperty("Log4jContextSelector", AsyncLoggerContextSelector.class.getName());
        System.setProperty("log4j.configurationFile", "AsyncLoggerTest.xml");
    }

    @AfterClass
    public static void afterClass() {
        System.setProperty("Log4jContextSelector", "");
    }

    @Test
    public void testAsyncLogUsesCachedThreadName() throws Exception {
        File file = new File("target", "AsyncLoggerTest.log");
        file.delete();
        Logger log = LogManager.getLogger((String)"com.foo.Bar");
        String msg = "Async logger msg";
        log.info("Async logger msg");
        Thread.currentThread().setName("MODIFIED-THREADNAME");
        log.info("Async logger msg");
        CoreLoggerContexts.stopLoggerContext(file);
        BufferedReader reader = new BufferedReader(new FileReader(file));
        String line1 = reader.readLine();
        String line2 = reader.readLine();
        reader.close();
        file.delete();
        Assert.assertNotNull((String)"line1", (Object)line1);
        Assert.assertNotNull((String)"line2", (Object)line2);
        Assert.assertTrue((String)"line1", (boolean)line1.endsWith(" INFO c.f.Bar [main]   Async logger msg "));
        Assert.assertTrue((String)"line2", (boolean)line2.endsWith(" INFO c.f.Bar [main]   Async logger msg "));
    }
}

