/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.appender.routing;

import java.io.File;
import java.util.Collections;
import java.util.Map;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.logging.log4j.EventLogger;
import org.apache.logging.log4j.junit.JndiRule;
import org.apache.logging.log4j.junit.LoggerContextRule;
import org.apache.logging.log4j.message.StructuredDataMessage;
import org.apache.logging.log4j.test.appender.ListAppender;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

public class RoutingAppenderWithJndiTest {
    public static final String JNDI_CONTEXT_NAME = "java:comp/env/logging/context-name";
    private ListAppender listAppender1;
    private ListAppender listAppender2;
    public static LoggerContextRule loggerContextRule = new LoggerContextRule("log4j-routing-by-jndi.xml");
    @ClassRule
    public static RuleChain rules = RuleChain.outerRule((TestRule)new JndiRule(RoutingAppenderWithJndiTest.initBindings())).around((TestRule)loggerContextRule);

    private static Map<String, Object> initBindings() {
        System.setProperty("log4j2.enableJndiLookup", "true");
        return Collections.emptyMap();
    }

    @Before
    public void before() {
        this.listAppender1 = loggerContextRule.getListAppender("List1");
        this.listAppender2 = loggerContextRule.getListAppender("List2");
    }

    @After
    public void after() {
        if (this.listAppender1 != null) {
            this.listAppender1.clear();
        }
        if (this.listAppender2 != null) {
            this.listAppender2.clear();
        }
    }

    @Test
    public void routingTest() throws NamingException {
        StructuredDataMessage msg = new StructuredDataMessage("Test", "This is a message from unknown context", "Context");
        EventLogger.logEvent((StructuredDataMessage)msg);
        File defaultLogFile = new File("target/routingbyjndi/routingbyjnditest-unknown.log");
        Assert.assertTrue((String)"The default log file was not created", (boolean)defaultLogFile.exists());
        InitialContext context = new InitialContext();
        context.bind(JNDI_CONTEXT_NAME, (Object)"Application1");
        msg = new StructuredDataMessage("Test", "This is a message from Application1", "Context");
        EventLogger.logEvent((StructuredDataMessage)msg);
        Assert.assertNotNull((String)"No events generated", this.listAppender1.getEvents());
        Assert.assertTrue((String)("Incorrect number of events. Expected 1, got " + this.listAppender1.getEvents().size()), (this.listAppender1.getEvents().size() == 1 ? 1 : 0) != 0);
        context.rebind(JNDI_CONTEXT_NAME, (Object)"Application2");
        msg = new StructuredDataMessage("Test", "This is a message from Application2", "Context");
        EventLogger.logEvent((StructuredDataMessage)msg);
        Assert.assertNotNull((String)"No events generated", this.listAppender2.getEvents());
        Assert.assertTrue((String)("Incorrect number of events. Expected 1, got " + this.listAppender2.getEvents().size()), (this.listAppender2.getEvents().size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((String)("Incorrect number of events. Expected 1, got " + this.listAppender1.getEvents().size()), (this.listAppender1.getEvents().size() == 1 ? 1 : 0) != 0);
        msg = new StructuredDataMessage("Test", "This is another message from Application2", "Context");
        EventLogger.logEvent((StructuredDataMessage)msg);
        Assert.assertNotNull((String)"No events generated", this.listAppender2.getEvents());
        Assert.assertTrue((String)("Incorrect number of events. Expected 2, got " + this.listAppender2.getEvents().size()), (this.listAppender2.getEvents().size() == 2 ? 1 : 0) != 0);
        Assert.assertTrue((String)("Incorrect number of events. Expected 1, got " + this.listAppender1.getEvents().size()), (this.listAppender1.getEvents().size() == 1 ? 1 : 0) != 0);
        context.rebind(JNDI_CONTEXT_NAME, (Object)"Application3");
        msg = new StructuredDataMessage("Test", "This is a message from Application3", "Context");
        EventLogger.logEvent((StructuredDataMessage)msg);
        File application3LogFile = new File("target/routingbyjndi/routingbyjnditest-Application3.log");
        Assert.assertTrue((String)"The Application3 log file was not created", (boolean)application3LogFile.exists());
        context.rebind(JNDI_CONTEXT_NAME, (Object)"Application4");
        msg = new StructuredDataMessage("Test", "This is a message from Application4", "Context");
        EventLogger.logEvent((StructuredDataMessage)msg);
        File application4LogFile = new File("target/routingbyjndi/routingbyjnditest-Application4.log");
        Assert.assertTrue((String)"The Application3 log file was not created", (boolean)application4LogFile.exists());
    }
}

